# -*- coding: utf-8 -*-
"""

MPFS
BILLING

Каталог продуктов для тестирования и разработки

"""
from mpfs.common.static.tags.billing import *

dev_p = [
    {
        ID: 'test_1kb_eternal',
        NAME: {
            RU_RU: u'ТЕСТ: вечный килобайт',
            UK_UA: u'ТЕСТ: вечный килобайт',
            EN_EN: u'TEST: eternal kb',
            TR_TR: u'TEST: eternal kb',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: True,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 1024,
        },
        ALTATTRS: False,
    },
    {
        ID: 'test_1kb_for_one_second',
        NAME: {
            RU_RU: u'ТЕСТ: секундный килобайт',
            UK_UA: u'ТЕСТ: секундный килобайт',
            EN_EN: u'TEST: kb for one second',
            TR_TR: u'TEST: kb for one second',
        },
        PERIOD: {
            SECOND: 1
        },
        AUTO: True,
        PROLONGABLE: True,
        PRICE: {USD: 1, RUB: 30},
        INAPP: True,
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 1024,
            NOTIFY_BEFORE: 1,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
        },
        ALTATTRS: False,
    },
    {
        ID: 'test_1kb_for_two_seconds',
        NAME: {
            RU_RU: u'ТЕСТ: двухсекундный килобайт',
            UK_UA: u'ТЕСТ: двухсекундный килобайт',
            EN_EN: u'TEST: kb for two second',
            TR_TR: u'TEST: kb for two second',
        },
        PERIOD: {
            SECOND: 2
        },
        AUTO: True,
        PROLONGABLE: True,
        PRICE: {USD: 1, RUB: 30},
        INAPP: True,
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 1024,
            NOTIFY_BEFORE: 1,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
        },
        ALTATTRS: False,
    },
    {
        ID: 'test_1kb_for_five_seconds',
        NAME: {
            RU_RU: u'ТЕСТ: пятисекундный килобайт',
            UK_UA: u'ТЕСТ: пятисекундный килобайт',
            EN_EN: u'TEST: kb for five second',
            TR_TR: u'TEST: kb for five second',
        },
        PERIOD: {
            SECOND: 5
        },
        AUTO: True,
        PROLONGABLE: True,
        PRICE: {USD: 1, RUB: 30},
        INAPP: True,
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 1024,
            NOTIFY_BEFORE: 1,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
        },
        ALTATTRS: False,
    },
{
        ID: 'test_1kb_for_five_seconds_with_attrs',
        NAME: {
            RU_RU: u'ТЕСТ: пятисекундный килобайт с атрибутами',
            UK_UA: u'ТЕСТ: пятисекундный килобайт с атрибутами',
            EN_EN: u'TEST: kb for five second with attributes',
            TR_TR: u'TEST: kb for five second with attributes',
        },
        PERIOD: {
            SECOND: 5
        },
        AUTO: True,
        PROLONGABLE: True,
        PRICE: {USD: 1, RUB: 30},
        INAPP: True,
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 0,
            NOTIFY_BEFORE: 1,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
        },
        ALTATTRS: True,
    },
    {
        ID: 'test_1kb_for_one_minute',
        NAME: {
            RU_RU: u'ТЕСТ: минутный килобайт',
            UK_UA: u'ТЕСТ: минутный килобайт',
            EN_EN: u'TEST: kb for one minute',
            TR_TR: u'TEST: kb for one minute',
        },
        PERIOD: {
            SECOND: 60
        },
        AUTO: True,
        PROLONGABLE: True,
        PRICE: {USD: 1, RUB: 30},
        INAPP: True,
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 1024,
            NOTIFY_BEFORE: 1,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
        },
        ALTATTRS: False,
    },
    {
        ID: 'test_1GB_for_five_minutes_for_1_rub',
        NAME: {
            RU_RU: u'ТЕСТ: пятиминутный 1 ГБ за 1 руб',
            UK_UA: u'ТЕСТ: пятиминутный 1 ГБ за 1 руб',
            EN_EN: u'TEST: 1 GB for five minute for 1 rub',
            TR_TR: u'TEST: 1 GB for five minute for 1 rub',
        },
        PERIOD: {
            SECOND: 300
        },
        AUTO: True,
        PROLONGABLE: True,
        PRICE: {RUB: 1},
        INAPP: True,
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 1073741824,
            NOTIFY_BEFORE: 60,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
        },
        ALTATTRS: False,
    },
    {
        ID: 'test_10GB_for_five_minutes',
        NAME: {
            RU_RU: u'ТЕСТ: пятиминутные 10 гигабайт',
            UK_UA: u'ТЕСТ: пятиминутные 10 гигабайт',
            EN_EN: u'TEST: 10 GB for five minute',
            TR_TR: u'TEST: 10 GB for five minute',
        },
        PERIOD: {
            SECOND: 300
        },
        AUTO: True,
        PROLONGABLE: True,
        PRICE: {USD: 1, RUB: 30},
        INAPP: True,
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 10737418240,
            NOTIFY_BEFORE: 60,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
        },
        ALTATTRS: False,
    },
    {
        ID: 'test_1kb_for_one_month',
        NAME: {
            RU_RU: u'ТЕСТ: месячный килобайт',
            UK_UA: u'ТЕСТ: месячный килобайт',
            EN_EN: u'TEST: kb for month',
            TR_TR: u'TEST: kb for month',
        },
        PERIOD: {
            MONTH: 1
        },
        AUTO: False,
        PROLONGABLE: False,
        PRICE: {USD: 1, RUB: 30},
        INAPP: True,
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 1024,
            NOTIFY_BEFORE: 259200,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
        },
        ALTATTRS: False,
    },
    {
        ID: 'test_10GB_for_10_minutes_with_10m_charging_retry_every_1m',
        NAME: {
            RU_RU: u'ТЕСТ: десятиминутные 10 гигабайт с добилливанием каждую минуту в течении 10 минут',
            UK_UA: u'ТЕСТ: десятиминутные 10 гигабайт с добилливанием каждую минуту в течении 10 минут',
            EN_EN: u'TEST: 10 GB for 10 minutes with 10m charging retry every 1m',
            TR_TR: u'TEST: 10 GB for 10 minutes with 10m charging retry every 1m',
        },
        PERIOD: {
            SECOND: 600
        },
        AUTO: True,
        PROLONGABLE: True,
        PRICE: {USD: 1, RUB: 30},
        INAPP: True,
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 1073741824,
            NOTIFY_BEFORE: 60,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
        },
        ALTATTRS: False,
        SUBS_RETRY_CHARGING_LIMIT: '600S',
        SUBS_RETRY_CHARGING_DELAY: '60S',
    },
    {
        ID: 'test_10GB_for_20_minutes_with_180m_charging_retry_every_10m',
        NAME: {
            RU_RU: u'ТЕСТ: 20-ти минутные 10 гигабайт с добилливанием каждые 10 минут в течении 3 часов',
            UK_UA: u'ТЕСТ: 20-ти минутные 10 гигабайт с добилливанием каждые 10 минут в течении 3 часов',
            EN_EN: u'TEST: 10 GB for 20 minutes with 3h charging retry every 10m',
            TR_TR: u'TEST: 10 GB for 20 minutes with 3h charging retry every 10m',
        },
        PERIOD: {
            SECOND: 1200
        },
        AUTO: True,
        PROLONGABLE: True,
        PRICE: {USD: 1, RUB: 1},
        INAPP: True,
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 1073741824,
            NOTIFY_BEFORE: 60,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
        },
        ALTATTRS: False,
        SUBS_RETRY_CHARGING_LIMIT: '10800S',
        SUBS_RETRY_CHARGING_DELAY: '600S',
        SUBS_GRACE_PERIOD: '10800S',
    },
    {
        ID: 'test_10GB_for_200_minutes_with_180m_charging_retry_every_10m',
        NAME: {
            RU_RU: u'ТЕСТ: 200-т минутные 10 гигабайт с добилливанием каждые 10 минут в течении 3 часов',
            UK_UA: u'ТЕСТ: 200-т минутные 10 гигабайт с добилливанием каждые 10 минут в течении 3 часов',
            EN_EN: u'TEST: 10 GB for 20 minutes with 3h charging retry every 10m',
            TR_TR: u'TEST: 10 GB for 20 minutes with 3h charging retry every 10m',
        },
        PERIOD: {
            SECOND: 12000
        },
        AUTO: True,
        PROLONGABLE: True,
        PRICE: {USD: 1, RUB: 1},
        INAPP: True,
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 1073741824,
            NOTIFY_BEFORE: 60,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
        },
        ALTATTRS: False,
        SUBS_RETRY_CHARGING_LIMIT: '10800S',
        SUBS_RETRY_CHARGING_DELAY: '600S',
        SUBS_GRACE_PERIOD: '10800S',
    },
]

group_dev_p = [
    {
        ID: 'test_group_1kb_eternal',
        NAME: {
            RU_RU: u'ТЕСТ: вечный килобайт',
            UK_UA: u'ТЕСТ: вечный килобайт',
            EN_EN: u'TEST: eternal kb',
            TR_TR: u'TEST: eternal kb',
        },
        PERIOD: None,
        AUTO: False,
        GROUP_TEMPLATE: True,
        GROUP_SIZE: 1,
        PROLONGABLE: False,
        INAPP: True,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 1024,
            NOTIFY_TEMPLATE_ON_CREATE: 'billing/service/createGroupMember',
        },
        ALTATTRS: False,
    },
    {
        ID: 'test_group_1kb_for_one_second',
        NAME: {
            RU_RU: u'ТЕСТ: секундный килобайт',
            UK_UA: u'ТЕСТ: секундный килобайт',
            EN_EN: u'TEST: kb for one second',
            TR_TR: u'TEST: kb for one second',
        },
        PERIOD: {
            SECOND: 1
        },
        AUTO: True,
        GROUP_TEMPLATE: True,
        GROUP_SIZE: 1,
        PROLONGABLE: True,
        PRICE: {USD: 1, RUB: 30},
        INAPP: True,
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 1024,
            NOTIFY_BEFORE: 1,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
            NOTIFY_TEMPLATE_ON_CREATE: 'billing/service/createGroupMember',
        },
        ALTATTRS: False,
    },
    {
        ID: 'test_group_1kb_for_two_seconds',
        NAME: {
            RU_RU: u'ТЕСТ: двухсекундный килобайт',
            UK_UA: u'ТЕСТ: двухсекундный килобайт',
            EN_EN: u'TEST: kb for two second',
            TR_TR: u'TEST: kb for two second',
        },
        PERIOD: {
            SECOND: 2
        },
        AUTO: True,
        GROUP_TEMPLATE: True,
        GROUP_SIZE: 1,
        PROLONGABLE: True,
        PRICE: {USD: 1, RUB: 30},
        INAPP: True,
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 1024,
            NOTIFY_BEFORE: 1,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
            NOTIFY_TEMPLATE_ON_CREATE: 'billing/service/createGroupMember',
        },
        ALTATTRS: False,
    },
    {
        ID: 'test_group_1kb_for_five_seconds',
        NAME: {
            RU_RU: u'ТЕСТ: пятисекундный килобайт',
            UK_UA: u'ТЕСТ: пятисекундный килобайт',
            EN_EN: u'TEST: kb for five second',
            TR_TR: u'TEST: kb for five second',
        },
        PERIOD: {
            SECOND: 5
        },
        AUTO: True,
        GROUP_TEMPLATE: True,
        GROUP_SIZE: 1,
        PROLONGABLE: True,
        PRICE: {USD: 1, RUB: 30},
        INAPP: True,
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 1024,
            NOTIFY_BEFORE: 1,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
            NOTIFY_TEMPLATE_ON_CREATE: 'billing/service/createGroupMember',
        },
        ALTATTRS: False,
    },
    {
        ID: 'test_group_1kb_for_one_minute',
        NAME: {
            RU_RU: u'ТЕСТ: минутный килобайт',
            UK_UA: u'ТЕСТ: минутный килобайт',
            EN_EN: u'TEST: kb for one minute',
            TR_TR: u'TEST: kb for one minute',
        },
        PERIOD: {
            SECOND: 60
        },
        AUTO: True,
        GROUP_TEMPLATE: True,
        GROUP_SIZE: 1,
        PROLONGABLE: True,
        PRICE: {USD: 1, RUB: 30},
        INAPP: True,
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 1024,
            NOTIFY_BEFORE: 1,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
            NOTIFY_TEMPLATE_ON_CREATE: 'billing/service/createGroupMember',
        },
        ALTATTRS: False,
    },
    {
        ID: 'test_group_10GB_for_five_minutes',
        NAME: {
            RU_RU: u'ТЕСТ: пятиминутные 10 гигабайт',
            UK_UA: u'ТЕСТ: пятиминутные 10 гигабайт',
            EN_EN: u'TEST: 10 GB for five minute',
            TR_TR: u'TEST: 10 GB for five minute',
        },
        PERIOD: {
            SECOND: 300
        },
        AUTO: True,
        GROUP_TEMPLATE: True,
        GROUP_SIZE: 1,
        PROLONGABLE: True,
        PRICE: {USD: 1, RUB: 30},
        INAPP: True,
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 10737418240,
            NOTIFY_BEFORE: 60,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
            NOTIFY_TEMPLATE_ON_CREATE: 'billing/service/createGroupMember',
        },
        ALTATTRS: False,
    },
    {
        ID: 'test_group_1kb_for_one_month',
        NAME: {
            RU_RU: u'ТЕСТ: месячный килобайт',
            UK_UA: u'ТЕСТ: месячный килобайт',
            EN_EN: u'TEST: kb for month',
            TR_TR: u'TEST: kb for month',
        },
        PERIOD: {
            MONTH: 1
        },
        AUTO: False,
        GROUP_TEMPLATE: True,
        GROUP_SIZE: 1,
        PROLONGABLE: False,
        PRICE: {USD: 1, RUB: 30},
        INAPP: True,
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 1024,
            NOTIFY_BEFORE: 259200,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
            NOTIFY_TEMPLATE_ON_CREATE: 'billing/service/createGroupMember',
        },
        ALTATTRS: False,
    },
    {
        ID: 'test_group_1kb_forever',
        NAME: {
            RU_RU: u'ТЕСТ: вечный килобайт',
            UK_UA: u'ТЕСТ: вечный килобайт',
            EN_EN: u'TEST: kb 4ever',
            TR_TR: u'TEST: kb 4ever',
        },
        PERIOD: None,
        AUTO: False,
        GROUP_TEMPLATE: True,
        GROUP_SIZE: 1,
        PROLONGABLE: False,
        PRICE: {USD: 1, RUB: 30},
        INAPP: True,
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 1024,
            NOTIFY_BEFORE: 259200,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
        },
        ALTATTRS: False,
    },
    {
        ID: 'ru.yandex.web.disk.native.20min.autorenewable.notrial.disk_basic.10.debug',
        NAME: {
            RU_RU: u'ТЕСТ: 20 минут 3 тб с Плюсом',
            UK_UA: u'ТЕСТ: 20 минут 3 тб с Плюсом',
            EN_EN: u'TEST: 3 TB for 20 minute with Plus',
            TR_TR: u'TEST: 3 TB for 20 minute with Plus',
        },
        PERIOD: {
            SECOND: 1200
        },
        AUTO: True,
        GROUP_TEMPLATE: True,
        GROUP_SIZE: 1,
        PROLONGABLE: True,
        PRICE: {USD: 0, RUB: 10},
        INAPP: True,
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 3298534883328,
            NOTIFY_BEFORE: 60,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
            IS_YANDEX_PLUS: True,
        },
        ALTATTRS: False,
    },
]
