# -*- coding: utf-8 -*-
"""
MPFS
BILLING

Каталог шаблонов групповых продуктов
Линейка 2016 года

https://st.yandex-team.ru/CHEMODAN-24050
"""
from mpfs.common.static.tags.billing import *

group_p_2016 = [
    {
        ID: '10gb_1m_2016_group',
        NAME: {
            RU_RU: u'10 ГБ',
            UK_UA: u'10 ГБ',
            EN_EN: u'10 GB',
            TR_TR: u'10 GB',
        },
        PERIOD: {
            MONTH: 1
        },
        AUTO: True,
        GROUP_TEMPLATE: True,  # групповой продукт, флажок нужен для того, чтобы отметить, что это шаблон,
                               # а не настоящий продукт. он используется, чтобы генерировать продукты
                               # для 1, 2, 3 и так далее пользователей https://st.yandex-team.ru/CHEMODAN-28280
        GROUP_SIZE: 1,  # для скольких пользователей этот групповой продукт предназначен
        PROLONGABLE: True,
        PRICE: {USD: 1, RUB: 25},
        PRICES_BY_QTY: {1: {USD: 1, RUB: 30}},  # спец. цены для определенного количества человек в группе,
                                                # для остального количества используется PRICE
        INAPP: False,
        MODULE: 'space',
        CLS: 'PayedSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 10737418240,
            NOTIFY_BEFORE: 259200,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
            NOTIFY_TEMPLATE_ON_CREATE: 'billing/service/createGroupMember',  # шаблон используется только для получателя
        },
        ALTATTRS: False,
    },
    {
        ID: '10gb_1y_2016_group',
        NAME: {
            RU_RU: u'10 ГБ',
            UK_UA: u'10 ГБ',
            EN_EN: u'10 GB',
            TR_TR: u'10 GB',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: True,
        GROUP_TEMPLATE: True,
        GROUP_SIZE: 1,
        PROLONGABLE: True,
        PRICE: {USD: 10, RUB: 250},
        PRICES_BY_QTY: {1: {USD: 10, RUB: 300}},
        INAPP: False,
        MODULE: 'space',
        CLS: 'PayedSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 10737418240,
            NOTIFY_BEFORE: 1209600,
            NOTIFY_TEMPLATE: 'billing/service/yearServiceEnds',
            NOTIFY_TEMPLATE_ON_CREATE: 'billing/service/createGroupMember',
        },
        ALTATTRS: False,
    },
    {
        ID: '100gb_1m_2016_group',
        NAME: {
            RU_RU: u'100 ГБ',
            UK_UA: u'100 ГБ',
            EN_EN: u'100 GB',
            TR_TR: u'100 GB',
        },
        PERIOD: {
            MONTH: 1
        },
        AUTO: True,
        GROUP_TEMPLATE: True,
        GROUP_SIZE: 1,
        PROLONGABLE: True,
        PRICE: {USD: 2, RUB: 70},
        PRICES_BY_QTY: {1: {USD: 2, RUB: 80}},
        INAPP: False,
        MODULE: 'space',
        CLS: 'PayedSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 107374182400,
            NOTIFY_BEFORE: 259200,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
            NOTIFY_TEMPLATE_ON_CREATE: 'billing/service/createGroupMember',
        },
        ALTATTRS: False,
    },
    {
        ID: '100gb_1y_2016_group',
        NAME: {
            RU_RU: u'100 ГБ',
            UK_UA: u'100 ГБ',
            EN_EN: u'100 GB',
            TR_TR: u'100 GB',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: True,
        GROUP_TEMPLATE: True,
        GROUP_SIZE: 1,
        PROLONGABLE: True,
        PRICE: {USD: 20, RUB: 700},
        PRICES_BY_QTY: {1: {USD: 20, RUB: 800}},
        INAPP: False,
        MODULE: 'space',
        CLS: 'PayedSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 107374182400,
            NOTIFY_BEFORE: 1209600,
            NOTIFY_TEMPLATE: 'billing/service/yearServiceEnds',
            NOTIFY_TEMPLATE_ON_CREATE: 'billing/service/createGroupMember',
        },
        ALTATTRS: False,
    },
    {
        ID: '1tb_1m_2016_group',
        NAME: {
            RU_RU: u'1 ТБ',
            UK_UA: u'1 ТБ',
            EN_EN: u'1 TB',
            TR_TR: u'1 TB',
        },
        PERIOD: {
            MONTH: 1
        },
        AUTO: True,
        GROUP_TEMPLATE: True,
        GROUP_SIZE: 1,
        PROLONGABLE: True,
        PRICE: {USD: 10, RUB: 180},
        PRICES_BY_QTY: {1: {USD: 10, RUB: 200}},
        INAPP: False,
        MODULE: 'space',
        CLS: 'PayedSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 1099511627776,
            NOTIFY_BEFORE: 259200,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
            NOTIFY_TEMPLATE_ON_CREATE: 'billing/service/createGroupMember',
        },
        ALTATTRS: False,
    },
    {
        ID: '1tb_1y_2016_group',
        NAME: {
            RU_RU: u'1 ТБ',
            UK_UA: u'1 ТБ',
            EN_EN: u'1 TB',
            TR_TR: u'1 TB',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: True,
        GROUP_TEMPLATE: True,
        GROUP_SIZE: 1,
        PROLONGABLE: True,
        PRICE: {USD: 100, RUB: 1800},
        PRICES_BY_QTY: {1: {USD: 100, RUB: 2000}},
        INAPP: False,
        MODULE: 'space',
        CLS: 'PayedSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 1099511627776,
            NOTIFY_BEFORE: 1209600,
            NOTIFY_TEMPLATE: 'billing/service/yearServiceEnds',
            NOTIFY_TEMPLATE_ON_CREATE: 'billing/service/createGroupMember',
        },
        ALTATTRS: False,
    },
    {
        ID: '250gb_forever_2016_group',
        NAME: {
            RU_RU: u'250 ГБ',
            UK_UA: u'250 ГБ',
            EN_EN: u'250 GB',
            TR_TR: u'250 GB',
        },
        PERIOD: None,
        AUTO: False,
        GROUP_TEMPLATE: True,
        GROUP_SIZE: 1,
        PROLONGABLE: True,
        PRICE: {USD: 250, RUB: 5000},
        PRICES_BY_QTY: {1: {USD: 250, RUB: 5000}},
        INAPP: False,
        MODULE: 'space',
        CLS: 'PayedSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 268435456000,
            NOTIFY_BEFORE: 1209600,
            NOTIFY_TEMPLATE: 'billing/service/yearServiceEnds',
        },
        ALTATTRS: False,
    }
]
