# -*- coding: utf-8 -*-
from copy import copy
from mpfs.common.static.tags.billing import *
from mpfs.core.billing.product.constants import SpaceBytes, Duration


class InAppProductPlaceholder(object):
    """Заполняет дефолтные поля для inapp продуктов"""
    DEFAULT_FIELDS = {
        AUTO: True,
        PROLONGABLE: True,
        INAPP: False,
        MODULE: 'space',
        CLS: 'PayedSpace',
        SINGLETON: False,
        ALTATTRS: False,
        SUBS_GRACE_PERIOD: '7D',
        PACKAGE_NAME: 'ru.yandex.disk',
    }

    @classmethod
    def extend(cls, product_dict):
        # change dict
        product_dict[SUBSCRIPTION_NAME] = copy(product_dict[NAME])
        for k, v in cls.DEFAULT_FIELDS.iteritems():
            if k not in product_dict:
                product_dict[k] = v
        return product_dict

    @staticmethod
    def set_store_id(product_list, store_id):
        # change product dict
        for product in product_list:
            product[STORE_ID] = store_id


_APPLE_APPSTORE = [
    {
        ID: '100gb_1y_apple_appstore_2019',
        NAME: {
            RU_RU: u'+ 100 GB на год в App Store',
            UK_UA: u'+ 100 GB на рік у App Store',
            EN_EN: u'+ 100 GB for a year in the App Store',
            TR_TR: u'App Store\'da 1 yıllık ek 100 GB aboneliği',
        },
        PERIOD: Duration.year,
        # https://st.yandex-team.ru/CHEMODAN-73897 24.99
        PRICE: {USD: '25', RUB: 1290},
        ATTRIBUTES: {AMOUNT: SpaceBytes.gb_100},
    },
    {
        ID: '100gb_1m_apple_appstore_2019',
        NAME: {
            RU_RU: u'+ 100 GB на месяц в App Store',
            UK_UA: u'+ 100 GB на місяць у App Store',
            EN_EN: u'+ 100 GB for a month in the App Store',
            TR_TR: u'App Store\'da 1 aylık ek 100 GB aboneliği',
        },
        PERIOD: Duration.month,
        # https://st.yandex-team.ru/CHEMODAN-73897 2.49
        PRICE: {USD: '3', RUB: 129},
        ATTRIBUTES: {AMOUNT: SpaceBytes.gb_100},
    },
    {
        ID: '1tb_1y_apple_appstore_2019',
        NAME: {
            RU_RU: u'+ 1 ТБ на год в App Store',
            UK_UA: u'+ 1 ТБ на рік у App Store',
            EN_EN: u'+ 1 TB for a year in the App Store',
            TR_TR: u'App Store\'da 1 yıllık ek 1 TB aboneliği',
        },
        PERIOD: Duration.year,
        # https://st.yandex-team.ru/CHEMODAN-73897 64.99
        PRICE: {USD: '65', RUB: 3250},
        ATTRIBUTES: {AMOUNT: SpaceBytes.tb_1},
    },
    {
        ID: '1tb_1m_apple_appstore_2019',
        NAME: {
            RU_RU: u'+ 1 ТБ на месяц в App Store',
            UK_UA: u'+ 1 ТБ на місяць у App Store',
            EN_EN: u'+ 1 TB for a month in the App Store',
            TR_TR: u'App Store\'da 1 aylık ek 1 TB aboneliği',
        },
        PERIOD: Duration.month,
        # https://st.yandex-team.ru/CHEMODAN-73897 7.99
        PRICE: {USD: '8', RUB: 399},
        ATTRIBUTES: {AMOUNT: SpaceBytes.tb_1},
    },
    {
        ID: '3tb_1y_apple_appstore_2019',
        NAME: {
            RU_RU: u'+ 3 ТБ на год в App Store',
            UK_UA: u'+ 3 ТБ на рік у App Store',
            EN_EN: u'+ 3 TB for a year in the App Store',
            TR_TR: u'App Store\'da 1 yıllık ek 3 TB aboneliği',
        },
        PERIOD: Duration.year,
        # https://st.yandex-team.ru/CHEMODAN-73897 199.99
        PRICE: {USD: '200', RUB: 9790},
        ATTRIBUTES: {AMOUNT: SpaceBytes.tb_3},
    },
    {
        ID: '3tb_1m_apple_appstore_2019',
        NAME: {
            RU_RU: u'+ 3 ТБ на месяц в App Store',
            UK_UA: u'+ 3 ТБ на місяць у App Store',
            EN_EN: u'+ 3 TB for a month in the App Store',
            TR_TR: u'App Store\'da 1 aylık ek 3 TB aboneliği',
        },
        PERIOD: Duration.month,
        # https://st.yandex-team.ru/CHEMODAN-73897 23.99
        PRICE: {USD: '24', RUB: 1190},
        ATTRIBUTES: {AMOUNT: SpaceBytes.tb_3},
    },
]
InAppProductPlaceholder.set_store_id(_APPLE_APPSTORE, APPLE_APPSTORE)

_GOOGLE_PLAY = [
    {
        ID: '100gb_1y_google_play_2019',
        NAME: {
            RU_RU: u'+ 100 GB на год в Google Play',
            UK_UA: u'+ 100 GB на рік у Google Play',
            EN_EN: u'+ 100 GB for a year in the Google Play',
            TR_TR: u'Google Play\'da 1 yıllık ek 100 GB aboneliği',
        },
        PERIOD: Duration.year,
        # https://st.yandex-team.ru/CHEMODAN-73897 24.99
        PRICE: {USD: '25', RUB: 1290},
        ATTRIBUTES: {AMOUNT: SpaceBytes.gb_100},
    },
    {
        ID: '100gb_1m_google_play_2019',
        NAME: {
            RU_RU: u'+ 100 GB на месяц в Google Play',
            UK_UA: u'+ 100 GB на місяць у Google Play',
            EN_EN: u'+ 100 GB for a month in the Google Play',
            TR_TR: u'Google Play\'da 1 aylık ek 100 GB aboneliği',
        },
        PERIOD: Duration.month,
        # https://st.yandex-team.ru/CHEMODAN-73897 2.49
        PRICE: {USD: '3', RUB: 129},
        ATTRIBUTES: {AMOUNT: SpaceBytes.gb_100},
    },
    {
        ID: '1tb_1y_google_play_2019',
        NAME: {
            RU_RU: u'+ 1 ТБ на год в Google Play',
            UK_UA: u'+ 1 ТБ на рік у Google Play',
            EN_EN: u'+ 1 TB for a year in the Google Play',
            TR_TR: u'Google Play\'da 1 yıllık ek 1 TB aboneliği',
        },
        PERIOD: Duration.year,
        # https://st.yandex-team.ru/CHEMODAN-73897 64.99
        PRICE: {USD: '65', RUB: 3250},
        ATTRIBUTES: {AMOUNT: SpaceBytes.tb_1},
    },
    {
        ID: '1tb_1m_google_play_2019',
        NAME: {
            RU_RU: u'+ 1 ТБ на месяц в Google Play',
            UK_UA: u'+ 1 ТБ на місяць у Google Play',
            EN_EN: u'+ 1 TB for a month in the Google Play',
            TR_TR: u'Google Play\'da 1 aylık ek 1 TB aboneliği',
        },
        PERIOD: Duration.month,
        # https://st.yandex-team.ru/CHEMODAN-73897 7.99
        PRICE: {USD: '8', RUB: 399},
        ATTRIBUTES: {AMOUNT: SpaceBytes.tb_1},
    },
    {
        ID: '3tb_1y_google_play_2019',
        NAME: {
            RU_RU: u'+ 3 ТБ на год в Google Play',
            UK_UA: u'+ 3 ТБ на рік у Google Play',
            EN_EN: u'+ 3 TB for a year in the Google Play',
            TR_TR: u'Google Play\'da 1 yıllık ek 3 TB aboneliği',
        },
        PERIOD: Duration.year,
        # https://st.yandex-team.ru/CHEMODAN-73897 199.99
        PRICE: {USD: '200', RUB: 9790},
        ATTRIBUTES: {AMOUNT: SpaceBytes.tb_3},
    },
    {
        ID: '3tb_1m_google_play_2019',
        NAME: {
            RU_RU: u'+ 3 ТБ на месяц в Google Play',
            UK_UA: u'+ 3 ТБ на місяць у Google Play',
            EN_EN: u'+ 3 TB for a month in the Google Play',
            TR_TR: u'Google Play\'da 1 aylık ek 3 TB aboneliği',
        },
        PERIOD: Duration.month,
        # https://st.yandex-team.ru/CHEMODAN-73897 23.99
        PRICE: {USD: '24', RUB: 1190},
        ATTRIBUTES: {AMOUNT: SpaceBytes.tb_3},
    },
]
InAppProductPlaceholder.set_store_id(_GOOGLE_PLAY, GOOGLE_PLAY)


class InAppProductsHolder(object):
    """Хранит все in-app словари-продукты и их id-ки"""
    # словари-продукты
    apple_appstore_products = [InAppProductPlaceholder.extend(p) for p in _APPLE_APPSTORE]
    google_play_products = [InAppProductPlaceholder.extend(p) for p in _GOOGLE_PLAY]
    all_products = apple_appstore_products + google_play_products

    # pid-ы
    apple_appstore_pids = {p[ID] for p in apple_appstore_products}
    google_play_pids = {p[ID] for p in google_play_products}
    all_pids = {p[ID] for p in all_products}
