# -*- coding: utf-8 -*-
"""

MPFS
BILLING

Каталог партнерских продуктов

"""
from mpfs.config import settings
from mpfs.common.static.tags.billing import *


partner_p = [
    {
        ID: 'rostelecom_2014_100gb',
        NAME: {
            RU_RU: u'Абонентам ОнЛайм',
            UK_UA: u'Абонентам ОнЛайм',
            EN_EN: u'For OnLime customers',
            TR_TR: u'OnLime aboneleri için',
        },
        PERIOD: {
            MONTH: 4
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 107374182400,
        },
        ALTATTRS: False,
        PARTNER: 'rostelecom',
        PARTNER_IPS: settings.billing['partner_ips']['rostelecom']
    },
    {
        ID: 'rostelecom_2015_100gb_paid',
        NAME: {
            RU_RU: u'Абонентам ОнЛайм',
            UK_UA: u'Абонентам ОнЛайм',
            EN_EN: u'For OnLime customers',
            TR_TR: u'OnLime aboneleri için',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 107374182400,
        },
        ALTATTRS: False,
        PARTNER: 'rostelecom',
        PARTNER_IPS: settings.billing['partner_ips']['rostelecom']
    },
    {
        ID: 'search_app_promo_gift',
        NAME: {
            RU_RU: u'Покупка нового смартфона',
            UK_UA: u'Покупка нового смартфона',
            EN_EN: u'Phone purchase promocode',
            TR_TR: u'Phone purchase promocode',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            # 50 GB
            AMOUNT: 53687091200,
        },
        ALTATTRS: False,
        PARTNER: 'search_app_promo'
    },
    {
        ID: 'yandex_plus_10gb',
        NAME: {
            RU_RU: u'Подписка Яндекс.Плюс',
            UK_UA: u'Передплата Яндекс.Плюс',
            EN_EN: u'Yandex.Plus subscription',
            TR_TR: u'Yandex.Plus aboneliği',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 10737418240,
        },
        ALTATTRS: False,
        PARTNER: 'yandex_plus',
        DISCOUNT_TEMPLATE_ID: 'dfb15dd3fcf64ebcad13144807de36db' if settings.feature_toggles['plus_discount_enabled'] else None
    },
    {
        ID: 'yandex_directory_1tb',
        NAME: {
            RU_RU: u'Диск Бизнес',
            UK_UA: u'Диск Бизнес',
            EN_EN: u'Диск Бизнес',
            TR_TR: u'Диск Бизнес',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 500},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 1099511627776,
        },
        ALTATTRS: False,
        PARTNER: 'yandex_directory'
    },
    {
        ID: 'yandex_disk_for_business',
        NAME: {
            RU_RU: u'Диск для Бизнеса',
            UK_UA: u'Яндекс.Диск для бізнесу',
            EN_EN: u'Yandex.Disk for Business',
            TR_TR: u'İşletmeler için Yandex.Disk',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 0,
        },
        ALTATTRS: True,
        PARTNER: 'yandex_ps_billing'
    },
    {
        ID: 'yandex_mail_pro',
        NAME: {
            RU_RU: u'Почта и Диск Про',
            UK_UA: u'Пошта і Диск Про',
            EN_EN: u'Mail and Disk Pro',
            TR_TR: u'Mail ve Disk Pro',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 0,
        },
        ALTATTRS: True,
        PARTNER: 'yandex_ps_billing'
    },
    {
        ID: 'yandex_b2c_mail_pro',
        NAME: {
            RU_RU: u'Яндекс 360',
            UK_UA: u'Яндекс 360',
            EN_EN: u'Yandex 360',
            TR_TR: u'Yandex 360',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 0,
        },
        ALTATTRS: True,
        PARTNER: 'yandex_ps_billing'
    },
    {
        ID: 'yandex_b2c_mail_pro_promo',
        NAME: {
            RU_RU: u'Яндекс 360 Промо',
            UK_UA: u'Яндекс 360 Промо',
            EN_EN: u'Yandex 360 Promo',
            TR_TR: u'Yandex 360 Promo',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 0,
        },
        ALTATTRS: True,
        PARTNER: 'yandex_ps_billing'
    },
    {
        ID: 'yandex_b2b_mail_pro',
        NAME: {
            RU_RU: u'Яндекс.Почта 360 для Бизнеса',
            UK_UA: u'Яндекс.Пошта 360 для бізнесу',
            EN_EN: u'Yandex.Mail 360 for Business',
            TR_TR: u'Yandex.Mail 360 for Business',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 0,
        },
        ALTATTRS: True,
        PARTNER: 'yandex_ps_billing'
    },
]
