# -*- coding: utf-8 -*-
"""
MPFS
BILLING

Каталог основных продуктов
Линейка 2015 года

https://st.yandex-team.ru/CHEMODAN-24050
"""
from mpfs.common.static.tags.billing import *


primary_p_2015 = [
    {
        ID: '10gb_1m_2015',
        NAME: {
            RU_RU: u'10 ГБ на месяц',
            UK_UA: u'10 ГБ на місяць',
            EN_EN: u'10 GB for a month',
            TR_TR: u'Aylık 10 GB',
        },
        SUBSCRIPTION_NAME: {
            RU_RU: u'Подписка 10 ГБ на месяц',
            UK_UA: u'Передплата 10 ГБ на місяць',
            EN_EN: u'10 GB monthly subscription',
            TR_TR: u'Aylık abonelik 10 GB',
        },
        PERIOD: {
            MONTH: 1
        },
        AUTO: True,
        PROLONGABLE: True,
        PRICE: {USD: 1, RUB: 30},
        INAPP: False,
        MODULE: 'space',
        CLS: 'PayedSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 10737418240,
            NOTIFY_BEFORE: 259200,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
        },
        ALTATTRS: False,
    },
    {
        ID: '10gb_1y_2015',
        NAME: {
            RU_RU: u'10 ГБ на год',
            UK_UA: u'10 ГБ на рік',
            EN_EN: u'10 GB for a year',
            TR_TR: u'Yıllık 10 GB',
        },
        SUBSCRIPTION_NAME: {
            RU_RU: u'Подписка 10 ГБ на год',
            UK_UA: u'Передплата 10 ГБ на рік',
            EN_EN: u'10 GB annual subscription',
            TR_TR: u'Yıllık abonelik 10 GB',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: True,
        PROLONGABLE: True,
        PRICE: {USD: 10, RUB: 300},
        INAPP: False,
        MODULE: 'space',
        CLS: 'PayedSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 10737418240,
            NOTIFY_BEFORE: 1209600,
            NOTIFY_TEMPLATE: 'billing/service/yearServiceEnds',
        },
        ALTATTRS: False,
    },
    {
        ID: '10gb_1y_sale_20_2015',
        NAME: {
            RU_RU: u'10 ГБ на год',
            UK_UA: u'10 ГБ на рік',
            EN_EN: u'10 GB for a year',
            TR_TR: u'Yıllık 10 GB',
        },
        SUBSCRIPTION_NAME: {
            RU_RU: u'Подписка 10 ГБ на год',
            UK_UA: u'Передплата 10 ГБ на рік',
            EN_EN: u'10 GB annual subscription',
            TR_TR: u'Yıllık abonelik 10 GB',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: True,
        PROLONGABLE: True,
        PRICE: {USD: 10, RUB: 240},
        INAPP: False,
        MODULE: 'space',
        CLS: 'PayedSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 10737418240,
            NOTIFY_BEFORE: 1209600,
            NOTIFY_TEMPLATE: 'billing/service/yearServiceEnds',
        },
        ALTATTRS: False,
    },
    {
        ID: '100gb_1m_2015',
        NAME: {
            RU_RU: u'100 ГБ на месяц',
            UK_UA: u'100 ГБ на місяць',
            EN_EN: u'100 GB for a month',
            TR_TR: u'Aylık 100 GB',
        },
        SUBSCRIPTION_NAME: {
            RU_RU: u'Подписка 100 ГБ на месяц',
            UK_UA: u'Передплата 100 ГБ на місяць',
            EN_EN: u'100 GB monthly subscription',
            TR_TR: u'Aylık abonelik 100 GB',
        },
        PERIOD: {
            MONTH: 1
        },
        AUTO: True,
        PROLONGABLE: True,
        PRICE: {USD: 2, RUB: 80},
        INAPP: False,
        MODULE: 'space',
        CLS: 'PayedSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 107374182400,
            NOTIFY_BEFORE: 259200,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
        },
        ALTATTRS: False,
    },
    {
        ID: '100gb_1y_2015',
        NAME: {
            RU_RU: u'100 ГБ на год',
            UK_UA: u'100 ГБ на рік',
            EN_EN: u'100 GB for a year',
            TR_TR: u'Yıllık 100 GB',
        },
        SUBSCRIPTION_NAME: {
            RU_RU: u'Подписка 100 ГБ на год',
            UK_UA: u'Передплата 100 ГБ на рік',
            EN_EN: u'100 GB annual subscription',
            TR_TR: u'Yıllık abonelik 100 GB',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: True,
        PROLONGABLE: True,
        PRICE: {USD: 20, RUB: 800},
        INAPP: False,
        MODULE: 'space',
        CLS: 'PayedSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 107374182400,
            NOTIFY_BEFORE: 1209600,
            NOTIFY_TEMPLATE: 'billing/service/yearServiceEnds',
        },
        ALTATTRS: False,
    },
    {
        ID: '100gb_1y_sale_20_2015',
        NAME: {
            RU_RU: u'100 ГБ на год',
            UK_UA: u'100 ГБ на рік',
            EN_EN: u'100 GB for a year',
            TR_TR: u'Yıllık 100 GB',
        },
        SUBSCRIPTION_NAME: {
            RU_RU: u'Подписка 100 ГБ на год',
            UK_UA: u'Передплата 100 ГБ на рік',
            EN_EN: u'100 GB annual subscription',
            TR_TR: u'Yıllık abonelik 100 GB',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: True,
        PROLONGABLE: True,
        PRICE: {USD: 20, RUB: 640},
        INAPP: False,
        MODULE: 'space',
        CLS: 'PayedSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 107374182400,
            NOTIFY_BEFORE: 1209600,
            NOTIFY_TEMPLATE: 'billing/service/yearServiceEnds',
        },
        ALTATTRS: False,
    },
    {
        ID: '1tb_1m_2015',
        NAME: {
            RU_RU: u'1 ТБ на месяц',
            UK_UA: u'1 ТБ на місяць',
            EN_EN: u'1 TB for a month',
            TR_TR: u'Aylık 1 TB',
        },
        SUBSCRIPTION_NAME: {
            RU_RU: u'Подписка 1 ТБ на месяц',
            UK_UA: u'Передплата 1 ТБ на місяць',
            EN_EN: u'1 TB monthly subscription',
            TR_TR: u'Aylık abonelik 1 TB',
        },
        PERIOD: {
            MONTH: 1
        },
        AUTO: True,
        PROLONGABLE: True,
        PRICE: {USD: 10, RUB: 200},
        INAPP: False,
        MODULE: 'space',
        CLS: 'PayedSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 1099511627776,
            NOTIFY_BEFORE: 259200,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
        },
        ALTATTRS: False,
    },
    {
        ID: '1tb_1y_2015',
        NAME: {
            RU_RU: u'1 ТБ на год',
            UK_UA: u'1 ТБ на рік',
            EN_EN: u'1 TB for a year',
            TR_TR: u'Yıllık 1 TB',
        },
        SUBSCRIPTION_NAME: {
            RU_RU: u'Подписка 1 ТБ на год',
            UK_UA: u'Передплата 1 ТБ на рік',
            EN_EN: u'1 TB annual subscription',
            TR_TR: u'Yıllık abonelik 1 TB',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: True,
        PROLONGABLE: True,
        PRICE: {USD: 100, RUB: 2000},
        INAPP: False,
        MODULE: 'space',
        CLS: 'PayedSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 1099511627776,
            NOTIFY_BEFORE: 1209600,
            NOTIFY_TEMPLATE: 'billing/service/yearServiceEnds',
        },
        ALTATTRS: False,
    },
    {
        ID: '1tb_1y_sale_20_2015',
        NAME: {
            RU_RU: u'1 ТБ на год',
            UK_UA: u'1 ТБ на рік',
            EN_EN: u'1 TB for a year',
            TR_TR: u'Yıllık 1 TB',
        },
        SUBSCRIPTION_NAME: {
            RU_RU: u'Подписка 1 ТБ на год',
            UK_UA: u'Передплата 1 ТБ на рік',
            EN_EN: u'1 TB annual subscription',
            TR_TR: u'Yıllık abonelik 1 TB',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: True,
        PROLONGABLE: True,
        PRICE: {USD: 100, RUB: 1600},
        INAPP: False,
        MODULE: 'space',
        CLS: 'PayedSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 1099511627776,
            NOTIFY_BEFORE: 1209600,
            NOTIFY_TEMPLATE: 'billing/service/yearServiceEnds',
        },
        ALTATTRS: False,
    },
]
