# -*- coding: utf-8 -*-
from mpfs.common.static import SPACE_1TB
from mpfs.common.static.tags.billing import *


third_p_2019 = [
    {
        ID: '3tb_1m_2019',
        NAME: {
            RU_RU: u'3 ТБ на месяц',
            UK_UA: u'3 ТБ на місяць',
            EN_EN: u'3 TB for a month',
            TR_TR: u'Aylık 3 TB',
        },
        SUBSCRIPTION_NAME: {
            RU_RU: u'Подписка 3 ТБ на месяц',
            UK_UA: u'Передплата 3 ТБ на місяць',
            EN_EN: u'3 TB monthly subscription',
            TR_TR: u'Aylık abonelik 3 TB',
        },
        PERIOD: {
            MONTH: 1
        },
        AUTO: True,
        PROLONGABLE: True,
        PRICE: {USD: 30, RUB: 900},
        INAPP: False,
        MODULE: 'space',
        CLS: 'PayedSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 3 * SPACE_1TB,
            NOTIFY_BEFORE: 259200,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
            DISABLES_MAIL_ADS: True,
        },
        ALTATTRS: False,
    },
    {
        ID: '3tb_1y_2019',
        NAME: {
            RU_RU: u'3 ТБ на год',
            UK_UA: u'3 ТБ на рік',
            EN_EN: u'3 TB for a year',
            TR_TR: u'Yıllık 3 TB',
        },
        SUBSCRIPTION_NAME: {
            RU_RU: u'Подписка 3 ТБ на год',
            UK_UA: u'Передплата 3 ТБ на рік',
            EN_EN: u'3 TB annual subscription',
            TR_TR: u'Yıllık abonelik 3   TB',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: True,
        PROLONGABLE: True,
        PRICE: {USD: 300, RUB: 7500},
        INAPP: False,
        MODULE: 'space',
        CLS: 'PayedSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 3 * SPACE_1TB,
            NOTIFY_BEFORE: 1209600,
            NOTIFY_TEMPLATE: 'billing/service/yearServiceEnds',
            DISABLES_MAIL_ADS: True,
        },
        ALTATTRS: False,
    },
]
