# -*- coding: utf-8 -*-
from mpfs.common.static import SPACE_1TB
from mpfs.common.static.tags.billing import *


third_p_2019_discount_20 = [
    {
        ID: '3tb_1m_2019_discount_20',
        NAME: {
            RU_RU: u'3 ТБ на месяц',
            UK_UA: u'3 ТБ на місяць',
            EN_EN: u'3 TB for a month',
            TR_TR: u'Aylık 3 TB',
        },
        SUBSCRIPTION_NAME: {
            RU_RU: u'Подписка 3 ТБ на месяц со скидкой 20%',
            UK_UA: u'Передплата 3 ТБ на місяць зі знижкою 20%',
            EN_EN: u'3 TB monthly subscription at a 20% discount',
            TR_TR: u'Aylık %20 indirimle 3 TB abonelik fırsatı',
        },
        PERIOD: {
            MONTH: 1
        },
        AUTO: True,
        PROLONGABLE: True,
        PRICE: {USD: 24, RUB: 720},
        INAPP: False,
        MODULE: 'space',
        CLS: 'PayedSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 3 * SPACE_1TB,
            NOTIFY_BEFORE: 259200,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
            DISABLES_MAIL_ADS: True,
        },
        ALTATTRS: False,
    },
    {
        ID: '3tb_1y_2019_discount_20',
        NAME: {
            RU_RU: u'3 ТБ на год',
            UK_UA: u'3 ТБ на рік',
            EN_EN: u'3 TB for a year',
            TR_TR: u'Yıllık 3 TB',
        },
        SUBSCRIPTION_NAME: {
            RU_RU: u'Подписка 3 ТБ на год со скидкой 20%',
            UK_UA: u'Передплата 3 ТБ на рік зі знижкою 20%',
            EN_EN: u'3 TB annual subscription at a 20% discount',
            TR_TR: u'Yıllık %20 indirimle 3 TB abonelik fırsatı',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: True,
        PROLONGABLE: True,
        PRICE: {USD: 240, RUB: 6000},
        INAPP: False,
        MODULE: 'space',
        CLS: 'PayedSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 3 * SPACE_1TB,
            NOTIFY_BEFORE: 1209600,
            NOTIFY_TEMPLATE: 'billing/service/yearServiceEnds',
            DISABLES_MAIL_ADS: True,
        },
        ALTATTRS: False,
    },
]
