# -*- coding: utf-8 -*-
"""

MPFS
BILLING

Каталог яндексовых продуктов

"""
from mpfs.config import settings
from mpfs.common.static.tags.billing import *


yandex_p = [
    {
        ID: 'yandex_staff',
        NAME: {
            RU_RU: u'Яндексоидам',
            UK_UA: u'Яндексоїдам',
            EN_EN: u'Yandexoids',
            TR_TR: u'Yandexoidler',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: settings.extra_space['yandexstaff']['value'],
        },
        ALTATTRS: False,
    },
    {
        ID: 'yandex_mail_birthday',
        NAME: {
            RU_RU: u'День рождения почтового ящика',
            UK_UA: u'День народження поштової скриньки',
            EN_EN: u'Your mail account’s birthday',
            TR_TR: u'E-posta hesabının doğum günü',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 0,
        },
        ALTATTRS: True,
    },
    {
        ID: 'yandex_mail_mobile_app_installation',
        NAME: {
            RU_RU: u'За установку мобильной Яндекс.Почты',
            UK_UA: u'За мобільну Яндекс.Пошту',
            EN_EN: u'For Mail app installation',
            TR_TR: u'Mobil Mail kurulumu için',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 17179869184,
            NOTIFY_TEMPLATE_ON_CREATE: 'spacePack/mobmail',
        },
        ALTATTRS: False,
    },
    {
        ID: 'blat',
        NAME: {
            RU_RU: u'Друзьям Яндекса',
            UK_UA: u'Друзям Яндекса',
            EN_EN: u'For friends of Yandex',
            TR_TR: u'Yandex dostları için',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 10737418240,
        },
        ALTATTRS: True,
    },
    {
        ID: 'blat_100',
        NAME: {
            RU_RU: u'Друзьям Яндекса',
            UK_UA: u'Друзям Яндекса',
            EN_EN: u'For friends of Yandex',
            TR_TR: u'Yandex dostları için',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: False,
        ATTRIBUTES: {
            AMOUNT: 107374182400,
        },
        ALTATTRS: False,
    },
    {
        ID: 'blat_250',
        NAME: {
            RU_RU: u'Друзьям Яндекса',
            UK_UA: u'Друзям Яндекса',
            EN_EN: u'For friends of Yandex',
            TR_TR: u'Yandex dostları için',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: settings.extra_space['blat250']['value'],
        },
        ALTATTRS: False,
    },
    {
        ID: 'passport_split',
        NAME: {
            RU_RU: u'Друзьям Яндекса',
            UK_UA: u'Друзям Яндекса',
            EN_EN: u'For friends of Yandex',
            TR_TR: u'Yandex dostları için',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: settings.extra_space['passportsplit']['value'],
        },
        ALTATTRS: False,
    },
    {
        ID: 'music_dec_2012',
        NAME: {
            RU_RU: u'Подписка на Яндекс.Музыку',
            UK_UA: u'Підписка на Яндекс.Музику',
            EN_EN: u'Yandex.Music subscription',
            TR_TR: u'Yandex.Müzik için abonelik',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: settings.extra_space['music']['value'],
        },
        ALTATTRS: False,
    },
    {
        ID: 'turkey_proje_y',
        NAME: {
            RU_RU: u'Друзьям Яндекса',
            UK_UA: u'Друзям Яндекса',
            EN_EN: u'For friends of Yandex',
            TR_TR: u'Yandex dostları için',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: settings.extra_space['turkeyprojey']['value'],
        },
        ALTATTRS: False,
    },
    {
        ID: 'turkey_panorama',
        NAME: {
            RU_RU: u'Друзьям Яндекса',
            UK_UA: u'Друзям Яндекса',
            EN_EN: u'For friends of Yandex',
            TR_TR: u'Yandex dostları için',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: settings.extra_space['turkeypanorama']['value'],
        },
        ALTATTRS: False,
    },
    {
        ID: 'acmicpc',
        NAME: {
            RU_RU: u'Участие в NEERC 2013',
            UK_UA: u'Участь у NEERC 2013',
            EN_EN: u'Participation in NEERC 2013',
            TR_TR: u"NEERC 2013'e katılım",
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 268435456000,
        },
        ALTATTRS: False,
    },
    {
        ID: 'yandex_shad',
        NAME: {
            RU_RU: u'Участникам Школы Анализа Данных',
            UK_UA: u'Учасникам Школи аналізу даних',
            EN_EN: u'For participants of the Yandex School of Data Analysis',
            TR_TR: u"Veri Analizi Okulu'nun katılımcıları için",
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: settings.extra_space['yandexshad']['value'],
        },
        ALTATTRS: False,
    },
    {
        ID: 'yandex_browser',
        NAME: {
            RU_RU: u'За Яндекс.Браузер',
            UK_UA: u'За Яндекс.Браузер',
            EN_EN: u'For Yandex.Browser',
            TR_TR: u'Yandex.Browser için',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: settings.extra_space['yandexbrowser']['value'],
        },
        ALTATTRS: False,
    },
    {
        ID: 'yandex_ege',
        NAME: {
            RU_RU: u'Подготовка к ЕГЭ',
            UK_UA: u'Підготовка до ЕГЭ',
            EN_EN: u'Preparation for university entrance exams',
            TR_TR: u'Üniversite sınavına hazırlık',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: settings.extra_space['yandexege']['value'],
        },
        ALTATTRS: False,
    },
    {
        ID: '20131201_install_fail',
        NAME: {
            RU_RU: u'От команды Яндекс.Диска',
            UK_UA: u'Від команди Яндекс.Диска',
            EN_EN: u'From the Yandex.Disk Team',
            TR_TR: u"Yandex.Disk Destek Ekibi'nden",
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 214748364800,
        },
        ALTATTRS: False,
    },
    {
        ID: 'yandex_video',
        NAME: {
            RU_RU: u'От Яндекс.Видео',
            UK_UA: u'Від Яндекс.Відео',
            EN_EN: u'From Yandex.Video',
            TR_TR: u"Yandex.Video'dan",
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 0,
        },
        ALTATTRS: True,
    },
    {
        ID: 'yandex_webchat',
        NAME: {
            RU_RU: u'Пользователям Я.Онлайна',
            UK_UA: u'Користувачам Я.Онлайну',
            EN_EN: u'Yandex.Online user',
            TR_TR: u'Yandex.Online kullanıcıları için',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 10737418240,
        },
        ALTATTRS: False,
    },
    {
        ID: 'common_fuckup',
        NAME: {
            RU_RU: u'Друзьям Яндекса',
            UK_UA: u'Друзям Яндекса',
            EN_EN: u'For friends of Yandex',
            TR_TR: u'Yandex dostları için',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 0,
        },
        ALTATTRS: True,
    },
    {
        # место, которое мы выдаем пользователям в качестве компенсации за закрытие Я.Фотки
        # изначально фотки будут положены в /attach и он безлимитный
        # но если пользователь захочет перенести оттуда фотки в /disk, то ему нужно компенсировать лишнее место
        # его мы ему и выдаем
        ID: 'fotki_closing_compensation',
        NAME: {
            RU_RU: u'Для снимков из Яндекс.Фоток',
            UK_UA: u'Для знімків із Яндекс.Фоток',
            EN_EN: u'For photos from Yandex.Fotki',
            TR_TR: u"Yandex.Foto'daki fotoğraflar için",
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 0,
        },
        ALTATTRS: True,
    },
    {
        ID: 'yandex_mail_ranktable',
        NAME: {
            RU_RU: u'Эксперт Яндекс.Почты',
            UK_UA: u'Експерт Яндекс.Пошти',
            EN_EN: u'Yandex.Mail Expert',
            TR_TR: u'Yandex.Mail uzmanı',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 10737418240,
        },
        ALTATTRS: False,
    },
    {
        ID: 'force_yandex_pro',
        NAME: {
            RU_RU: u'ТЕСТ: 0 байт навсегда (Диск.Про)',
            UK_UA: u'ТЕСТ: 0 байт навсегда (Диск.Про)',
            EN_EN: u'TEST: 0 bytes forever (Disk.Pro)',
            TR_TR: u'TEST: 0 bytes forever (Disk.Pro)',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 0,
        },
        ALTATTRS: False,
    },
]
