# -*- coding: utf-8 -*-
from mpfs.common.static import SPACE_1GB, SPACE_1TB
from mpfs.common.static.tags.billing import *

yandex_plus_upsale_2019 = [
    {
        ID: 'ru.yandex.web.disk.native.1month.autorenewable.notrial.disk_basic.750',
        NAME: {
            RU_RU: u'3 ТБ и Яндекс.Плюс на месяц',
            UK_UA: u'3 ТБ та Яндекс.Плюс на місяць',
            EN_EN: u'3 TB and Yandex.Plus for a month',
            TR_TR: u'1 aylık 3 TB + Yandex.Plus',
        },
        # TODO: а надо ли NAME или достаточно SUBSCRIPTION_NAME
        SUBSCRIPTION_NAME: {
            RU_RU: u'Подписка 3 ТБ и Яндекс.Плюс на месяц',
            UK_UA: u'Передплата 3 ТБ та Яндекс.Плюс на місяць',
            EN_EN: u'3 TB and Yandex.Plus monthly subscription',
            TR_TR: u'1 aylık 3 TB + Yandex.Plus aboneliği',
        },
        PERIOD: {
            MONTH: 1
        },
        AUTO: True,
        PROLONGABLE: True,
        PRICE: {RUB: 750, USD: 0},  # Продаем только в РФ,без USD не можем завести в биллинге стандартным скриптом
        INAPP: False,
        MODULE: 'space',
        CLS: 'PayedSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 3 * SPACE_1TB,
            NOTIFY_BEFORE: 259200,
            NOTIFY_TEMPLATE: 'billing/service/monthServiceEnds',
            IS_YANDEX_PLUS: True,
            DISABLES_MAIL_ADS: True,
        },
        PARTNER: 'yandex_plus',
        ALTATTRS: False,
    },
    {
        ID: 'ru.yandex.web.disk.native.1year.autorenewable.notrial.disk_basic.6500',
        NAME: {
            RU_RU: u'3 ТБ и Яндекс.Плюс на год',
            UK_UA: u'3 ТБ та Яндекс.Плюс на рік',
            EN_EN: u'3 TB and Yandex.Plus for a year',
            TR_TR: u'Yıllık 3 TB + Yandex.Plus',
        },
        SUBSCRIPTION_NAME: {
            RU_RU: u'Подписка 3 ТБ и Яндекс.Плюс на год',
            UK_UA: u'Передплата 3 ТБ та Яндекс.Плюс на рік',
            EN_EN: u'3 TB and Yandex.Plus yearly subscription',
            TR_TR: u'1 yıllık 3 TB + Yandex.Plus aboneliği',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: True,
        PROLONGABLE: True,
        PRICE: {RUB: 6500, USD: 0},  # Продаем только в РФ,без USD не можем завести в биллинге стандартным скриптом
        INAPP: False,
        MODULE: 'space',
        CLS: 'PayedSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 3 * SPACE_1TB,
            NOTIFY_BEFORE: 259200,
            NOTIFY_TEMPLATE: 'billing/service/yearServiceEnds',
            IS_YANDEX_PLUS: True,
            DISABLES_MAIL_ADS: True,
        },
        PARTNER: 'yandex_plus',
        ALTATTRS: False,
    },
    {
        ID: 'ru.yandex.web.disk.native.1month.autorenewable.notrial.disk_100gb.69',
        # TODO: локализация пока не нужна
        NAME: {
            RU_RU: u'+100 ГБ на Яндекс.Диск',
            UK_UA: u'+100 ГБ на Яндекс.Диск',
            EN_EN: u'+100 ГБ на Яндекс.Диск',
            TR_TR: u'+100 ГБ на Яндекс.Диск',
        },
        # TODO: а надо ли NAME или достаточно SUBSCRIPTION_NAME
        SUBSCRIPTION_NAME: {
            RU_RU: u'+100 ГБ на Яндекс.Диск',
            UK_UA: u'+100 ГБ на Яндекс.Диск',
            EN_EN: u'+100 ГБ на Яндекс.Диск',
            TR_TR: u'+100 ГБ на Яндекс.Диск',
        },
        PERIOD: {
            MONTH: 1
        },
        AUTO: True,
        PROLONGABLE: True,
        PRICE: {RUB: 69, USD: 0},  # Продаем только в РФ,без USD не можем завести в биллинге стандартным скриптом
        INAPP: False,
        MODULE: 'space',
        CLS: 'PayedSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 100 * SPACE_1GB,
            IS_YANDEX_PLUS: True,
            DISABLES_MAIL_ADS: False,
        },
        PARTNER: 'yandex_plus',
        ALTATTRS: False,
    }
]
