# -*- coding: utf-8 -*-
from time import time

from mpfs.common.static.tags import experiment_names
from mpfs.common.static.tags.billing import *
from mpfs.common.util.experiments.logic import experiment_manager
from mpfs.core.billing.constants import PRODUCT_INITIAL_10GB_ID, DEFAULT_SERVICE_ID


class DefaultProductsService(object):
    DEFAULT_PRODUCT_ID = PRODUCT_INITIAL_10GB_ID
    PRODUCT_INITIAL_5GB_ID = 'initial_5gb'

    ALL_INITIAL_PRODUCT_IDS = (DEFAULT_PRODUCT_ID, PRODUCT_INITIAL_5GB_ID)

    @staticmethod
    def get_product_id():
        product_id = DefaultProductsService.DEFAULT_PRODUCT_ID

        if experiment_manager.is_feature_active(experiment_names.INITIAL_5GB):
            product_id = DefaultProductsService.PRODUCT_INITIAL_5GB_ID

        return product_id

    @staticmethod
    def get_by_product_id(product_id):
        from mpfs.core.billing import Product
        # 10GB by default
        if not product_id:
            product_id = DefaultProductsService.DEFAULT_PRODUCT_ID

        return Product(product_id)

    @staticmethod
    def construct_default_service(uid, product_id=None):
        """Отдает сформированную услугу.

        Дефолтные услуги не храним в базке. При запросе списка услуг нужно сформировать
        виртуальные дефолтные услуги и выдать вместе с услугами из DB.
        """
        from mpfs.core.billing import Product

        if not product_id:
            from mpfs.core.user.base import User
            product_id = User(uid).get_default_product_id()

        if not product_id:
            product_id = DefaultProductsService.DEFAULT_PRODUCT_ID

        product = Product(product_id)
        current_time = time()
        current_time_ms = int(current_time * 1000)
        current_time = int(current_time)

        return {
            PRODUCT: product,
            PID: product_id,
            SID: DEFAULT_SERVICE_ID,
            BTIME: None,
            DELETETIME: None,
            LASTBTIME: current_time,
            GROUP: False,
            PARENT_SID: None,
            UID: uid,
            AUTO: product.auto,
            STATE: None,
            MTIME: current_time,
            CHILD_SIDS: None,
            ENABLED: True,
            CTIME: current_time,
            V: current_time_ms
        }

    @staticmethod
    def should_add_default_service(params):
        """Определяет стоит ли в рамках запроса учитывать виртуальную дефолтную услугу."""
        return (UID in params and
                not any(key in params
                        for key in (BTIME, STATE, PID, ORIGINAL_TRANSACTION_ID)))

    @staticmethod
    def has_initial_service(uid):
        from mpfs.core.billing import Client
        from mpfs.core.billing import ServiceList

        client = Client(uid)
        user_services = ServiceList(client=client)
        user_services_pids = [s[PRODUCT].id for s in user_services]

        for initial_product_id in DefaultProductsService.ALL_INITIAL_PRODUCT_IDS:
            if initial_product_id in user_services_pids:
                return True

        return False
