# -*- coding: utf-8 -*-
"""

MPFS
BILLING

Фабрика услуг и все такое, что рядом

"""
from time import time

import mpfs.engine.process

from mpfs.config import settings
from mpfs.common.util import loader
from mpfs.common.static.tags.billing import *
from mpfs.common.errors import billing as errors
from mpfs.core.billing.client import Client
from mpfs.core.billing.constants import (
    PRODUCT_INITIAL_10GB_ID,
    DEFAULT_SERVICE_ID,
)
from mpfs.core.billing.product import Product
from mpfs.core.billing.product.default_products_service import DefaultProductsService
from mpfs.core.billing.service.attributes import LoadAllServiceAttributes, LoadAllServiceAttributesHistory
from mpfs.core.billing.service.common import CommonService, ArchiveService


log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()
SUBSCRIPTION_CANCELLED_DELAY = settings.billing['subscription_payment_cancel']
DEFAULT_SERVICE_PID = PRODUCT_INITIAL_10GB_ID


def Service(sid, **kwargs):
    '''
    Конструктор конретной услуги
    '''
    service = CommonService(sid, **kwargs)
    product = Product(service.pid)

    klassname = 'mpfs.core.billing.service.%s.%s' % (product.module, product.cls)
    cls = loader.import_class(klassname)
    service.__class__ = cls

    return service


def ServiceCreate(client, product, auto=False, btime=None):
    '''
    Создание услуги
    '''
    klassname = 'mpfs.core.billing.service.%s.%s' % (product.module, product.cls)
    cls = loader.import_class(klassname)  # type: CommonService

    if product.singleton:
        services = ServiceList(client=client)
        services_with_same_product = filter(lambda x: x['pid'] == product.pid and x['sid'] != DEFAULT_SERVICE_ID, services)
        if services_with_same_product:
            raise errors.BillingProductIsSingletone(product.pid,
                                                    prev_created_service_info=services_with_same_product[0])

    return cls.Create(client, product, auto=auto)


def ServiceList(**kwargs):
    '''
    Листинги услуг по конкретным запросам
    '''
    result = []
    params = {}

    if CLIENT in kwargs:
        params[UID] = kwargs[CLIENT].uid
    if BTIME_LT in kwargs:
        params[BTIME] = {'$lt': kwargs[BTIME_LT]}
    if BTIME_GTE in kwargs:
        if BTIME in params:
            params[BTIME]['$gte'] = kwargs[BTIME_GTE]
        else:
            params[BTIME] = {'$gte': kwargs[BTIME_GTE]}
    if STATE in kwargs:
        state = kwargs[STATE]
        if isinstance(state, list):
            params[STATE] = {'$in': state}
        else:
            params[STATE] = state
    if PRODUCT in kwargs:
        product = kwargs[PRODUCT]
        if isinstance(product, list):
            params[PID] = {'$in': product}
        else:
            params[PID] = product
    if ORIGINAL_TRANSACTION_ID in kwargs:
        params[ORIGINAL_TRANSACTION_ID] = {'$in': kwargs[ORIGINAL_TRANSACTION_ID]}

    alt_attrs = {}
    if CLIENT in kwargs:
        alt_attrs = LoadAllServiceAttributes(kwargs[CLIENT].uid)

    has_default_service = False

    for item in CommonService.table.get_all(**params):
        product = Product(item[PID])
        sid = str(item.pop(CommonService.pkey))

        if sid in alt_attrs:
            for key, value in alt_attrs[sid].iteritems():
                setattr(product.attributes, key, value)

        item[SID] = sid
        item[PRODUCT] = product
        item[DELETETIME] = item[BTIME]
        if isinstance(item[BTIME], (int, long, float)) and item[STATE] == PAYMENT_CANCELLED:
            item[DELETETIME] = item[BTIME] + SUBSCRIPTION_CANCELLED_DELAY

        if getattr(product, GROUP_TEMPLATE, False):
            item[GROUP] = True

        if item.get(CHILD_SIDS):
            group_uids = []
            for child_item in CommonService.table.get_all(**{'_id': {'$in': item[CHILD_SIDS]}}):
                group_uids.append(child_item[UID])
            item[GROUP_UIDS] = group_uids

        if item.get(PARENT_SID):
            parent_item = CommonService.table.get_one(**{'_id': item[PARENT_SID]})
            if parent_item:
                item[BUYER_UID] = parent_item[UID]

        if item[PID] == DEFAULT_SERVICE_PID:
            has_default_service = True

        result.append(item)

    # add default service
    if (not has_default_service and
            DefaultProductsService.should_add_default_service(params)):
        uid = params.get(UID)
        default_service = DefaultProductsService.construct_default_service(uid)
        result.append(default_service)

    return result


def ServiceListHistory(**kwargs):
    if CLIENT in kwargs:
        alt_attrs = LoadAllServiceAttributesHistory(kwargs[CLIENT].uid)

        result = []
        params = {UID: kwargs[CLIENT].uid}

        if PRODUCT in kwargs:
            product = kwargs[PRODUCT]
            if isinstance(product, list):
                params[PID] = {"$in": product}
            else:
                params[PID] = product

        for item in ArchiveService.table.get_all(**params):
            product = Product(item[PID])
            sid = str(item.get(SID))

            if sid in alt_attrs:
                for key, value in alt_attrs[sid].iteritems():
                    setattr(product.attributes, key, value)

            item[PRODUCT] = product

            if item[STATE] == PAYMENT_CANCELLED:
                item[DELETETIME] = item[BTIME] + SUBSCRIPTION_CANCELLED_DELAY
            elif (item[BTIME] and item[BTIME] > item[MTIME]) or item[BTIME] is None:
                item[DELETETIME] = item[MTIME]
            else:
                item[DELETETIME] = item[BTIME]

            result.append(item)
        return result


def get_service_by_pid(uid, pid):
    client = Client(uid)
    services = ServiceList(client=client)
    for service in services:
        if service[PID] == pid:
            return Service(service[SID])
