# -*- coding: utf-8 -*-
"""

MPFS
BILLING

Атрибуты услуги

"""
import copy
from collections import defaultdict

import mpfs.engine.process

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()

from mpfs.common.static.tags.billing import * 
from mpfs.core.billing.entity import EmptyEntity
from mpfs.core.metastorage.control import billing_service_attributes, billing_service_attributes_history


def LoadAllServiceAttributes(uid):
    result = defaultdict(dict)
    params = {UID: uid}
    for item in billing_service_attributes.get_all(**params):
        sid = item[DB_ID]
        del item[DB_ID]
        del item[V]
        result[sid].update(item)
    return result


def LoadAllServiceAttributesHistory(uid):
    result = defaultdict(dict)
    params = {UID: uid}
    for item in billing_service_attributes_history.get_all(**params):
        sid = item[DB_ID]
        del item[DB_ID]
        del item[V]
        result[sid].update(item)
    return result


class ServiceAttributes(EmptyEntity):
    
    table = billing_service_attributes
    uniq_key_name = SID
    
    def __init__(self, sid, uid, **kwargs):
        super(ServiceAttributes, self).__init__(sid, **kwargs)
        self._data[UID] = uid
    
    def iteritems(self):
        data = copy.copy(self.dict())
        del data[self.pkey]
        return data.iteritems()

    def delete(self):
        billing_service_attributes_history.put(self.dict())
        super(ServiceAttributes, self).delete()


class ArchivedServiceAttributes(ServiceAttributes):
    table = billing_service_attributes_history

    def restore(self):
        billing_service_attributes.put(self.dict())
        EmptyEntity.delete(self)

