# -*- coding: utf-8 -*-
"""

MPFS
BILLING

Услуга пространства

"""
import mpfs.engine.process
from mpfs.common.util.experiments.logic import experiment_manager

from mpfs.common.static.tags.billing import *
from mpfs.common.errors import billing as errors
import mpfs.common.errors as errors
from mpfs.core.billing import ServiceList
from mpfs.core.billing.processing.common import calculate_billing_time
from mpfs.core.overdraft.notifications import send_push, send_email_for_light
from mpfs.core.user.base import User
from mpfs.core.billing.service.common import CommonService
from mpfs.core.billing.client import Client
from mpfs.core.filesystem.base import Filesystem
from mpfs.core.pushnotifier.queue import PushQueue
from mpfs.core.billing.processing import notify as mail_notify
from mpfs.common.static.tags.push import QUOTA, SERVICE_PROLONGATION
from mpfs.core.user.standart import PAID_PRODUCTS_IDS, PS_BILLING_PRODUCT_IDS
from mpfs.core.user.constants import IS_PAID_WITHOUT_PS_BILLING


fs = Filesystem()
push_queue = PushQueue()

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()


class CommonSpace(CommonService):

    def process_enable(self, send_email=True, **kwargs):
        user = User(self.uid)
        if not user.is_standart:
            return

        product = self.product
        amount = product.attributes.amount

        if self.group and self.child_sids:  # если групповая услуга и я владелец этой группы
            amount = 0
        elif self.state in ServiceState.not_provide_service:
            amount = 0
        else:
            user.enlarge_space(amount, reason=product.pid)
            if product.pid in PAID_PRODUCTS_IDS:
                user.set_is_paid(True)
                if product.pid not in PS_BILLING_PRODUCT_IDS:
                    user.set_setting(IS_PAID_WITHOUT_PS_BILLING, True )

        space_info = fs.quota.report(self.uid)
        new_limit = space_info['limit']
        limit = new_limit - amount

        if amount:
            if send_email:
                client = Client(self.uid)
                mail_notify.service_create(client, self)
            self._push_notify(product, limit, new_limit, space_info, type='added')
            log.info(
                '%s enlarged space %s => %s (reason: %s, added %s)' %
                (self.uid, limit, new_limit, product.pid, amount)
            )

    def process_disable(self, send_email=True):
        user = User(self.uid)
        if not user.is_standart:
            return

        client = Client(self.uid)

        product = self.product
        amount = product.attributes.amount

        if self.group and self.child_sids:  # если групповая услуга и я владелец этой группы
            amount = 0
        else:
            user.reduce_space(amount, reason=product.pid)
            if product.pid in PAID_PRODUCTS_IDS:
                client = Client(self.uid)
                service_list = ServiceList(client=client)
                paid_services = [s for s in service_list if s['pid'] in PAID_PRODUCTS_IDS]
                if self.nothing_left([s['sid'] for s in paid_services]):
                    user.set_is_paid(False)

                paid_without_ps_billing_sids = [s['sid'] for s in paid_services if s['pid'] not in PS_BILLING_PRODUCT_IDS]
                if self.nothing_left(paid_without_ps_billing_sids):
                    self.remove_is_paid_without_ps_billing_setting(user)

        space_info = fs.quota.report(self.uid)
        new_limit = space_info['limit']
        limit = new_limit + amount

        if amount:
            self._push_notify(product, limit, new_limit, space_info, type='reduced')
            if send_email:
                mail_notify.service_deleted(client, self)
            log.info(
                '%s reduced space %s => %s (reason: %s, reduced %s, send_email: %s)' %
                (self.uid, limit, new_limit, product.pid, amount, send_email)
            )

            experiment_manager.update_context(uid=self.uid)
            if user.is_in_overdraft_for_restrictions() and \
                experiment_manager.is_feature_active('new_overdraft_strategy'):
                user.set_overdraft_info(force=not user.is_in_overdraft_for_restrictions(additional_space=amount))
                send_push(self.uid)
                space = user.fs.quota.report(self.uid)
                send_email_for_light(self.uid, space['used'], space['limit'])

    def nothing_left(self, sids):
        return not sids or (len(sids) == 1 and sids[0] == self.sid)

    @staticmethod
    def remove_is_paid_without_ps_billing_setting(user):
        try:
            user.remove_setting(IS_PAID_WITHOUT_PS_BILLING)
        except errors.SettingStateNotFound:
            pass

    def process_prolongation(self, status):
        if status == SUCCESS:
            next_billing, last_billing = calculate_billing_time(self)
            self.set(BTIME, next_billing, save_to_db=False)
            self.set(LASTBTIME, last_billing, save_to_db=False)

        self.remove(NOTIFIED, save_to_db=False)
        self.save()

        if status == SUCCESS:
            xiva_data = {
                'class': SERVICE_PROLONGATION,
                'uid': self.uid,
                'xiva_data': {
                    'root': {
                        'tag': SERVICE_PROLONGATION,
                        'parameters': {
                            'state': "success"
                        }
                    }
                }
            }
            push_queue.put(xiva_data)

    def _postprocess_altattr(self, attr, old=None, new=None):
        if attr == AMOUNT:
            self._process_flexible_amount(int(old), int(new))

    def _push_notify(self, product, limit, new_limit, space_info, type='added'):
        amount = product.attributes.amount

        data = {
            'class': QUOTA,
            'uid': self.uid,
            'xiva_data': {
                'root': {
                    "tag" : "quota",
                    "parameters": {}
                }
            }
        }

        data['xiva_data']['root']['parameters'].update(space_info)
        data['xiva_data']['root']['parameters']['paid'] = not product.free()

        if type == 'added':
            data['xiva_data']['root']['parameters']['add'] = amount
        elif type == 'reduced':
            data['xiva_data']['root']['parameters']['reduced'] = amount

        push_queue.put(data)


    def _process_flexible_amount(self, old, new):
        user = User(self.uid)
        product = self.product

        difference = new - old

        space_info = fs.quota.report(self.uid)
        limit = space_info['limit']
        new_limit = limit + difference
        push_type = None

        if difference == 0:
            return
        elif difference > 0:
            push_marker = 'added'
            log_marker = 'enlarged'
            user.enlarge_space(difference, reason=product.pid)
        elif difference < 0:
            push_marker = 'reduced'
            log_marker = 'reduced'
            user.reduce_space(-difference, reason=product.pid)

        space_info = fs.quota.report(self.uid)
        self._push_notify(product, limit, new_limit, space_info, type=push_marker)
        log.info(
            '%s %s space %s => %s (reason: %s, difference %s)' %
            (self.uid, log_marker, limit, new_limit, product.pid, difference)
        )


class BonusSpace(CommonSpace):

    pass


class PayedSpace(CommonSpace):

    pass
