# -*- coding: utf-8 -*-
import mpfs.engine.process

from collections import defaultdict

from mpfs.core.metastorage.control import browser, browser_states
from mpfs.core.metastorage.decorators import slave_read_ok
from mpfs.core.pushnotifier.sync.controller import BrowserPushController
from mpfs.core.queue import mpfs_queue
from mpfs.common.errors.browser import SyncUserNotFound
from mpfs.common.errors import JsonBodyExpectedError
from mpfs.common.util import from_json
from mpfs.config import settings


log = mpfs.engine.process.get_default_log()
BROWSER_SEND_PUSH_NOTIFICATIONS = settings.browser['send_push_notifications']


def commit(req):
    if req.entities:
        put_result = browser.put_data(req.entities)
        uid = put_result.uid

        if BROWSER_SEND_PUSH_NOTIFICATIONS:
            push_data = {
                         'uid' : uid,
                         'xiva_data' : dict((str(t), v) for (t,v) in put_result.versions.iteritems()),
                         'action_name' : 'diff_browser',
                         'client_id' : req.client_id,
                         }
            mpfs_queue.put(push_data, 'xiva_browser')

        return put_result.value


def delete(req):
    entities = from_json(req.entities)
    delete_result = browser.delete_data(entities, req.uid)
    return delete_result.value


@slave_read_ok
def get_updates(req):
    result = browser.diff(req.uid, req.types, None, limit=req.limit)
    return {'o' : result.value, 's' : result.states}


def drop(req):
    drop_result = browser.drop(req.uid)
    if BROWSER_SEND_PUSH_NOTIFICATIONS:
        push_data = {
                     'uid' : req.uid,
                     'xiva_data' : drop_result,
                     'action_name' : 'diff_browser',
                     'client_id' : req.client_id,
                     }
        mpfs_queue.put(push_data, 'xiva_browser')


def delete_subtree(req):
    pass

def subscribe(req):
    BrowserPushController().subscribe(req.uid, req.callback, req.options)


def unsubscribe(req):
    BrowserPushController().unsubscribe(req.uid, req.callback, req.client_id)


def set_state(req):
    browser_states.set_state(req.uid, req.states)


def get_state(req):
    return browser_states.get_state(req.uid)


def set_state_with_version(req):
    return browser_states.set_state(req.uid, req.states, is_version_specified=True, version=req.version)


def get_state_with_version(req):
    return browser_states.get_state(req.uid, append_version=True)


@slave_read_ok
def user_info(req):
    result = {}
    try:
        response = browser_states.user_info(req.uid)
    except SyncUserNotFound:
        result['types'] = {}
    else:
        result['types'] = response
    return result


def notify(request):
    if not request.http_req.data:
        raise JsonBodyExpectedError()

    notification_data = from_json(request.http_req.data)
    push_data = {
        'uid': request.uid,
        'xiva_data': notification_data,
        'action_name': 'diff_browser',
        'client_id': request.client_id,
    }
    mpfs_queue.put(push_data, 'xiva_browser')
