# -*- coding: utf-8 -*-

import mpfs.engine.process

from mpfs.config import settings
from mpfs.core.filesystem.base import Filesystem
from mpfs.core.queue import mpfs_queue
from mpfs.common.static.tags.push import Full, Low
from mpfs.core.services.fotki_proxy_service import fotki_proxy_service

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()


class _proxy(object):
    def __init__(self, method, args):
        self.method = method
        self.args = args

    def __call__(self, *args, **kwargs):
        request = self.args.get('request')
        if hasattr(request, 'connection_id'):
            self.args['connection_id'] = connection_id = request.connection_id
        else:
            connection_id = self.args.get('connection_id', '')

        fs = Filesystem(method=self.method, **self.args)
        result = getattr(fs, self.method)(*args, **kwargs)

        from mpfs.core.filesystem.helpers.counter import Counter
        Counter().commit()

        if fs.fotki_proxy_urls:
            for proxy_url in fs.fotki_proxy_urls:
                mpfs_queue.put({'proxy_url': proxy_url}, 'remove_from_fotki_proxy', deduplication_id=proxy_url)

        for each_item in fs.push_content:
            # set `connection_id`
            if 'connection_id' not in each_item:
                each_item['connection_id'] = connection_id
            if not each_item['connection_id']:
                each_item.pop('connection_id')
            push_deduplication_id = None
            if each_item.get('action_name') == 'space' and each_item.get('class') in (Full.klass, Low.klass):
                push_deduplication_id = 'xiva_push_%s__%s_%s' % (each_item['action_name'], each_item['class'], each_item['uid'])
            if settings.feature_toggles['send_xiva_push_notification']:
                mpfs_queue.put(each_item, 'xiva', deduplication_id=push_deduplication_id)

        for op_subtype, op_data in fs.email_content.iteritems():
            for each_item in op_data:
                deduplication_id = None
                if op_subtype == 'send_email_space' and each_item.get('template') in (Full.template, Low.template):
                    deduplication_id = '%s__%s_%s' % (op_subtype, each_item['template'], each_item['uid'])
                mpfs_queue.put(each_item, op_subtype, deduplication_id=deduplication_id)

        for op_subtype, op_data in fs.job_content.iteritems():
            for each_item in op_data:
                if 'extra' in each_item and each_item.get('extra', {}).get('xiva'):
                    each_item['extra']['xiva']['connection_id'] = connection_id
                    each_item['extra']['xiva']['operation'] = 'action'
                mpfs_queue.put(each_item, op_subtype)

        fs.disk_indexer.flush_index_data()
        return result


class Bus(object):
    def __init__(self, **kw):
        self.__args__ = kw

    def __getattribute__(self, *args, **kwargs):
        if args[0] in ('__args__',):
            return super(Bus, self).__getattribute__(*args, **kwargs)
        else:
            p = _proxy(args[0], self.__args__)
            return p
