# -*- coding: utf-8 -*-
"""
MPFS Client

Сущность для хранения настроек прав доступа конкретного клиента MPFS.
"""
from mpfs.common.static.tags.conf_sections import TVM2


class MPFSClient(object):
    """Клиент MPFS

    Usage:

    >>> client = MPFSClient({'auth_methods': ["tvm_2_0"], 'tvm_2_0': {'client_ids': [109, 110]}}, 'verstka')
    >>> client.name
    'verstka'
    >>> client.auth_methods
    ['tvm_2_0']
    >>> client.has_tvm_2_0
    True
    >>> client.tvm_2_0
    {'client_ids': [109, 110]}
    >>> client.tvm_2_0['client_ids']
    [109, 110]

    """
    def __init__(self, name, auth_conf):
        self.name = name
        self._conf = auth_conf

    @property
    def auth_methods(self):
        return self._conf.keys()

    def has_tvm_2_0(self):
        return TVM2 in self.auth_methods

    @property
    def tvm_2_0(self):
        if self.has_tvm_2_0():
            return self._conf[TVM2]
        else:
            None
