# -*- coding: utf-8 -*-

from mpfs.core.comments.logic.comments_owner import get_resource_owner
from mpfs.core.comments.logic.comments_permissions import get_comment_permissions_for_uid
from mpfs.core.comments.logic.info_by_comment_id import get_resource_by_comment_id


def comments_permissions(req):
    """Получить набор разрешенных действий для комментирования

    Query string аргументы:
        * entity_type [обязательный] - тип комментируемой сущности
        * entity_id [обязательный] - id ресурса
        * uid [обязательный] - uid пользователя, для которого надо получить разрешения по комментированию ресурса.
    """
    return get_comment_permissions_for_uid(req.entity_type, req.entity_id, req.uid)


def comments_owner(req):
    return {'is_owner': get_resource_owner(req.entity_type, req.entity_id) == req.uid}


def info_by_comment_id(req):
    """Получить ресурс по uid и comment_id. В случае корневой ОП будет возвращен ресурс для указанного уида, то есть
    для владельца и приглашенных он будет различаться

     Query string аргументы:
        * entity_type [обязательный] - тип комментируемой сущности
        * entity_id [обязательный] - id ресурса (comment_id)
        * uid [обязательный] - uid пользователя, для которого надо получить разрешения по комментированию ресурса.
        * meta - мета
    """
    resource = get_resource_by_comment_id(req.entity_type, req.entity_id, req.uid)
    resource.set_request(req)
    return resource
