# -*- coding: utf-8 -*-
from mpfs.common.errors import ResourceNotFound
from mpfs.common.errors.share import (
    ShareNotFound,
)
from mpfs.core import factory
from mpfs.core.address import ResourceId
from mpfs.core.comments import errors
from mpfs.core.filesystem.resources.group import GroupRootFolder
from mpfs.core.user.constants import PHOTOUNLIM_AREA_PATH


def get_resource_by_comment_id(entity_type, entity_id, uid):
    resource_id = ResourceId.parse(entity_id)
    if entity_type == 'private_resource':
        resource = _get_private_resource_by_comment_id(resource_id, uid)
    elif entity_type == 'public_resource':
        resource = _get_public_resource_by_comment_id(resource_id)
    else:
        raise errors.BadEntityType()
    return resource


def _get_private_resource_by_comment_id(resource_id, uid):
    resource = factory.get_resources_by_resource_ids(uid, [resource_id], enable_service_ids=['/disk'],
                                                     enable_optimization=True)[0]
    if resource is not None:
        return resource

    # Обрабатываем случай, когда пытаемся получить корневую расшаренную папку
    resource = factory.get_resources_by_resource_ids(resource_id.uid, [resource_id], enable_service_ids=['/disk'],
                                                     enable_optimization=True)[0]
    if resource is None or not resource.is_group_root:
        raise ResourceNotFound()
    try:
        group_link = resource.group.get_link_by_uid(uid)
    except ShareNotFound:
        raise ResourceNotFound()
    else:
        return group_link.get_folder()


def _get_public_resource_by_comment_id(resource_id):
    resource = factory.get_resources_by_resource_ids(
        resource_id.uid, [resource_id], enable_service_ids=['/disk', PHOTOUNLIM_AREA_PATH], enable_optimization=True)[0]
    if resource is None or not resource.is_fully_public():
        raise ResourceNotFound()
    return resource
