# -*- coding: utf-8 -*-
from copy import copy


class CommentPermissions(object):
    """
    Класс для представления разрешений для комментариев.
    """

    def __init__(self, view=False, comment=False, clean=False, disable=False):
        self.permissions = {
            'view': view,
            'comment': comment,
            'clean': clean,
            'disable': disable,
        }

    def permit(self, action):
        if self._check_action_exists(action):
            self.permissions[action] = True

    def bulk_permit(self, actions):
        for action in actions:
            self.permit(action)

    def forbid(self, action):
        if self._check_action_exists(action):
            self.permissions[action] = False

    def bulk_forbid(self, actions):
        for action in actions:
            self.forbid(action)

    def as_dict(self):
        return copy(self.permissions)

    @staticmethod
    def create_all_permissions():
        return CommentPermissions(view=True, comment=True, clean=True, disable=True)

    @staticmethod
    def create_owner_permissions():
        return CommentPermissions(view=True, comment=True, clean=True)

    @staticmethod
    def create_read_only_permissions():
        return CommentPermissions(view=True, comment=True)

    def _check_action_exists(self, action):
        return action in self.permissions
