# -*- coding: utf-8 -*-

from mpfs.common.errors.common import MPFSError
from mpfs.common.static import codes


class FileRecoveryError(MPFSError):
    pass


class UnsupportedRecoveryReport(FileRecoveryError):
    pass


class ResourceIDMissmatch(FileRecoveryError):
    pass


class FileNotOnRecoveryError(FileRecoveryError):
    code = codes.FILE_NOT_ON_RECOVERY


class StoreByHashesDisabled(FileRecoveryError):
    code = codes.STORE_BY_HASHES_DISABLED
