# -*- coding: utf-8 -*-

from mpfs.config import settings
from mpfs.core.operations.manager import create_operation
from mpfs.core.file_recovery.operations import RestoreFileOperation
from mpfs.core.file_recovery.errors import StoreByHashesDisabled

FILE_RECOVERY_ENABLE_REPORT_PROCESSING = settings.file_recovery['enable_store_by_hashes']


def restore_file(req):
    if not FILE_RECOVERY_ENABLE_REPORT_PROCESSING:
        raise StoreByHashesDisabled()

    operation = create_operation(
        req.uid,
        RestoreFileOperation.type,
        RestoreFileOperation.subtype,
        {
            'store_md5': req.md5,
            'store_sha256': req.sha256,
            'store_size': req.size,
        }
    )
    return {
        'upload_url': operation['upload_url'],
        'oid': operation.id,
        'type': operation.type,
        'at_version': operation.at_version
    }
