# -*- coding: utf-8 -*-
import click


@click.command('retry_remove', help=u"Почистить stid-ы из коллекции deleted_stids_retry_remove")
@click.option("--dry-run", help=u"Не удалять на самом деле", is_flag=True)
@click.option("--threads", help=u"Количество тредов (default: 20)", default=20)
def retry_remove(dry_run, threads):
    from multiprocessing.pool import ThreadPool
    import mpfs.engine.process
    mpfs.engine.process.setup_admin_script()
    from mpfs.core.services.mulca_service import Mulca
    from mpfs.core.filesystem.cleaner.models import DeletedStidRetry

    mulca_service = Mulca()

    def mulca_remove(stid):
        if dry_run:
            return

        try:
            response_code = mulca_service.remove(stid.stid)
        except Exception:
            response_code = 500
        if 200 <= response_code < 300 or response_code in {400, 404}:
            stid.delete()

    pool = ThreadPool(processes=threads)
    pool.imap_unordered(mulca_remove, DeletedStidRetry.controller.iter_all())
    pool.close()
    pool.join()
