# -*- coding: utf-8 -*-
import datetime

from mpfs.core.models import Model, ModelField


class DeletedStidSources(object):
    ADMIN_UNZIP_MIDS = 'admin_unzip_mids'
    DAO_UPDATE_FILE = 'dao_update_file'
    HARDLINK_UPDATE_TASK = 'hardlink_update_task'
    HIDDEN_DATA_CLEAN = 'hidden_data_clean'
    KLADUN_CLEAN_UP = 'kladun_clean_up'
    MARK_STID_DELETED = 'mark_stid_deleted'
    REGENERATE_DIGEST = 'regenerate_digest'
    REGENERATE_PREVIEW = 'regenerate_preview'
    UPDATE_SOCIAL_COVER = 'update_social_cover'
    VERSIONING = 'versioning'
    HANGING_STORAGE_DUPLICATES = 'hanging_storage_duplicates'


class DeletedStid(Model):
    primary_key_field = 'stid'
    stid = ModelField(required=True, source='_id')
    ctime = ModelField(required=True)
    stid_type = ModelField()
    hid = ModelField()
    size = ModelField()
    stid_source = ModelField()

    def __init__(self, **kwargs):
        super(DeletedStid, self).__init__(**kwargs)
        if not isinstance(kwargs.get('ctime'), datetime.datetime):
            self.ctime = datetime.datetime.now()


class DeletedStidRetry(DeletedStid):
    pass


class StorageCleanCheckStid(Model):
    primary_key_field = 'stid'
    stid = ModelField(required=True, source='_id')
    counter = ModelField(required=True)
    ctime = ModelField(required=True)

    def __init__(self, **kwargs):
        super(StorageCleanCheckStid, self).__init__(**kwargs)
        if not isinstance(kwargs.get('ctime'), datetime.datetime):
            self.ctime = datetime.datetime.now()

    def save(self, *args, **kwargs):
        if not self.ctime:
            self.ctime = datetime.datetime.now()
        super(StorageCleanCheckStid, self).save(*args, **kwargs)
