import random

import mpfs.engine.process
from mpfs.common.util import chunks2
from mpfs.core.filesystem.cleaner.models import DeletedStid, DeletedStidSources
from mpfs.core.filesystem.dao.storage_duplicates import StorageDuplicatesDAO
from mpfs.core.queue import mpfs_queue
from mpfs.engine.queue2.celery import BaseTask, app
from mpfs.metastorage.postgres.query_executer import PGQueryExecuter

default_log = mpfs.engine.process.get_default_log()


@app.task(base=BaseTask)
def handle_storage_duplicate_clean(shard_name):
    if not shard_name:
        default_log.info('No shard name.')
        return
    storage_duplicates_dao = StorageDuplicatesDAO()
    hanging_duplicates = list(storage_duplicates_dao.find_hanging_duplicates(shard_name))
    for chunk in chunks2(hanging_duplicates, chunk_size=200):
        deleted_stids_objs = []
        for duplicate in chunk:
            deleted_stids_objs.append(
                DeletedStid(
                    stid=duplicate['stid'],
                    stid_type='duplicate_stid',
                    hid=duplicate['storage_id'],
                    size=None,
                    stid_source=DeletedStidSources.HANGING_STORAGE_DUPLICATES,
                )
            )
        DeletedStid.controller.bulk_create(deleted_stids_objs, get_size_from_storage=True)
        storage_duplicates_dao.delete(list(duplicate['storage_id'] for duplicate in chunk), shard_name)


class StorageDuplicatesCleanerManager(object):
    def run(self):
        shard_names = PGQueryExecuter().get_all_shard_ids()
        random.shuffle(shard_names)
        for shard in shard_names:
            if not shard:
                continue
            mpfs_queue.put({'shard_name': shard}, 'storage_duplicate_clean',
                           deduplication_id='storage_duplicate_clean__%s' % shard)
