# coding=utf-8
import os
import click


@click.command('put_to_recovery',
               help=u"отправить файлы в систему восстановления.")
@click.option('--paths', '-p', multiple=True, type=click.STRING, help=u"формат -p uid:path -p uid:path ...")
def put_to_recovery(paths):
    print paths

    import mpfs.engine.process
    if os.geteuid() != 0:
        mpfs.engine.process.setup_anyone_script()
    else:
        mpfs.engine.process.setup_admin_script()

    from mpfs.core.factory import get_resource_by_address
    from mpfs.common.errors import ResourceNotFound
    from mpfs.core.address import Address

    for path in paths:
        print path
        addr = Address(path)
        try:
            resource = get_resource_by_address(addr.uid, addr)
        except ResourceNotFound:
            print "ENOTFOUND: %s" % addr
        else:
            from mpfs.core.services.mulca_service import Mulca
            if Mulca().is_file_exist(resource.file_mid()):
                print "FOUND: %s" % addr
            else:
                from mpfs.core.file_recovery.logic.processors import put_file_on_recovery
                put_status = put_file_on_recovery(resource)
                print "OK: %s %s" % (addr, put_status)
