# -*- coding: utf-8 -*-
import os
import click


@click.command('regenerate_stid_for_all', help=u"Перегенерить превьюшку или дайджест. Так же обновляет stid у всех файлов в БД")
@click.argument('stid_type', type=click.Choice(['preview', 'digest']))
@click.argument('raw_address', nargs=1, type=click.STRING)
def regenerate_stid_for_all(stid_type, raw_address):
    import mpfs.engine.process
    if os.geteuid() != 0:
        mpfs.engine.process.setup_anyone_script()
    else:
        mpfs.engine.process.setup_admin_script()

    from mpfs.core.bus import Bus
    from mpfs.core.address import Address

    address = Address(raw_address)
    fs = Bus()
    click.echo("Start %s stid regeneration" % stid_type)

    if stid_type == 'preview':
        fs.regenerate_preview_for_all_resources(address)
    elif stid_type == 'digest':
        fs.regenerate_digest_for_all_resources(address)
    else:
        raise NotImplementedError('unknown stid_type')

    click.echo("Done!")
