# -*- coding: utf-8 -*-
import mpfs.engine.process
from mpfs.core.albums.dao.album_items import AlbumItemDAO
from mpfs.core.albums.dao.albums import AlbumDAO
from mpfs.core.filesystem.dao.changelog import ChangelogDAO
from mpfs.core.filesystem.dao.disk_info.disk_info import DiskInfoDAO
from mpfs.core.filesystem.dao.filesystem_lock import FilesystemLockDAO
from mpfs.core.filesystem.dao.misc_data import MiscDataDAO
from mpfs.core.filesystem.dao.recount import RecountDAO
from mpfs.core.filesystem.dao.resource import ResourceDAO, TrashDAO, HiddenDAO, NarodDAO, AttachDAO, NotesDAO, \
    PhotounlimDAO, AdditionalDataDAO, ClientDAO
from mpfs.core.filesystem.dao.storage_duplicates import StorageDuplicatesDAO
from mpfs.core.filesystem.dao.trash_cleaner_queue import TrashCleanerQueueDAO
from mpfs.core.office.dao.office_allowed_pdd_domains import OfficeAllowedPddDomainsDAO
from mpfs.core.operations.dao.operation import OperationDAO
from mpfs.core.social.dao.group_invites import GroupInvitesDAO
from mpfs.core.social.dao.group_links import GroupLinksDAO
from mpfs.core.social.dao.groups import GroupsDAO
from mpfs.core.social.dao.link_data import LinkDataDAO
from mpfs.core.support.dao.support_block_history import SupportBlockHistoryDAO
from mpfs.core.support.dao.support_blocked_hids import SupportBlockedHidsDAO
from mpfs.core.support.dao.support_moderation_queue import SupportModerationQueueDAO
from mpfs.core.support.dao.support_mpfs import SupportMpfsDAO
from mpfs.core.support.dao.support_prohibited_cleaning_users import SupportProhibitedCleaningUsersDAO
from mpfs.core.user.dao.user import UserDAO
from mpfs.engine.queue2.async_tasks.dao.async_tasks_data import AsyncTasksDataDAO


class CollectionRoutedDatabase(object):
    """Класс, подставляющийся в наследник BaseCollection вместо аттрибута `self.db`.

    Нужен только для того, чтобы в зависимости от того, какую коллекцию возвращали, отдавалась либо настоящая монговая,
    либо фейковая, которая ходит в DAO.
    """
    def __init__(self):
        # У биллинга в mpfs.core.billing.__init__.py образовывается цикл импортов
        from mpfs.core.billing.dao.billing_locks import BillingLocksDAO
        from mpfs.core.billing.dao.billing_orders import BillingOrdersDAO
        from mpfs.core.billing.dao.billing_orders_history import BillingOrdersHistoryDAO
        from mpfs.core.billing.dao.billing_service_attributes import BillingServiceAttributesDAO
        from mpfs.core.billing.dao.billing_services import BillingServicesDAO
        from mpfs.core.billing.dao.billing_services_history import BillingServicesHistoryDAO
        from mpfs.core.billing.dao.billing_subscriptions import BillingSubscriptionsDAO

        self._db = mpfs.engine.process.dbctl().database()
        self.collection_to_dao_map = {
            'additional_data': AdditionalDataDAO(),
            'albums': AlbumDAO(),
            'album_items': AlbumItemDAO(),
            'async_tasks_data': AsyncTasksDataDAO(),
            'changelog': ChangelogDAO(),
            'filesystem_locks': FilesystemLockDAO(),
            'link_data': LinkDataDAO(),
            'misc_data': MiscDataDAO(),
            'storage_duplicates': StorageDuplicatesDAO(),
            'operations': OperationDAO(),
            'user_data': ResourceDAO(),
            'trash': TrashDAO(),
            'trash_cleaner_queue': TrashCleanerQueueDAO(),
            'hidden_data': HiddenDAO(),
            'user_index': UserDAO(),
            'disk_info': DiskInfoDAO(),
            'narod_data': NarodDAO(),
            'attach_data': AttachDAO(),
            'notes_data': NotesDAO(),
            'photounlim_data': PhotounlimDAO(),
            'client_data': ClientDAO(),
            'billing_locks': BillingLocksDAO(),
            'billing_orders': BillingOrdersDAO(),
            'billing_orders_history': BillingOrdersHistoryDAO(),
            'billing_service_attributes': BillingServiceAttributesDAO(),
            'billing_services': BillingServicesDAO(),
            'billing_services_history': BillingServicesHistoryDAO(),
            'billing_subscriptions': BillingSubscriptionsDAO(),
            'support_blocked_hids': SupportBlockedHidsDAO(),
            'support_mpfs': SupportMpfsDAO(),
            'support_prohibited_cleaning_users': SupportProhibitedCleaningUsersDAO(),
            'support_moderation_queue': SupportModerationQueueDAO(),
            'support_block_history': SupportBlockHistoryDAO(),
            'groups': GroupsDAO(),
            'group_invites': GroupInvitesDAO(),
            'group_links': GroupLinksDAO(),
            'office_allowed_pdd_domains': OfficeAllowedPddDomainsDAO(),
            'recount': RecountDAO(),
        }

    def __getattr__(self, name):
        return self[name]  # нужно, чтобы был доступ как self.db.user_data, некоторый код написан почему-то так

    def __getitem__(self, item):
        if item in self.collection_to_dao_map:
            return self.collection_to_dao_map[item]
        return self._db[item]

    def is_collection_uses_dao(self, coll_name):
        return coll_name in self.collection_to_dao_map.keys()


def is_collection_uses_dao(coll_name):
    return CollectionRoutedDatabase().is_collection_uses_dao(coll_name)


def is_new_fs_spec_required(coll_name):
    return coll_name in (
        'user_data', 'trash', 'hidden_data', 'narod_data', 'attach_data', 'notes_data', 'photounlim_data',
        'additional_data', 'client_data'
    )
