# -*- coding: utf-8 -*-


class Move(object):
    pass


class MoveShared(Move):

    '''
        Переименование и перемещение групповых ресурсов
        - корневой групповой каталог - общий каталог для владельца этого каталога, 
            в нем физически находятся все элементы
        - корневой расшаренный каталог - общий каталог для человека, добавелнного в группу,
            в нем физически нет данных
    '''

    def rename_top_shared_folder(self):
        '''
            Переименование, перемещение корневого расшаренного каталога,
            обновляется group_link и запись каталога в user_data
        '''
        pass

    def rename_top_group_folder(self):
        '''
            Переименование, перемещение корневого группового каталога,
            обновляется group_link и запись каталога в user_data
        '''
        pass

    def rename_resource_in_shared(self):
        '''
            Переименование элемента внутри расшаренного каталога
            
        '''
        pass

    def move_resource_in_shared(self):
        '''
            Перенос элемента внутри расшаренного каталога
        '''
        pass

    def move_resource_from_shared(self):
        '''
            Перенос элемента из расшаренного каталога в личное пространство диска.
            Обновляется размер занятого группой пространства, размер личного пространства пользователя.
        '''
        pass

    def move_resource_to_shared(self):
        '''
            Перенос элемента в расшаренный каталог
        '''
        pass

    def move_folder_with_shared_child(self):
        '''
            Перенос каталога, в котором есть расшаренный
        '''
        pass


class Trash(object):
    pass


class TrashShared(Trash):
    pass


class append_top_shared_folder(TrashShared):
    '''
        Перенос в корзину корневого расшаренного каталога
    '''
    def do(self):
        pass


class append_top_group_folder(TrashShared):
    '''
        Перенос в корзину корневого 
    '''
    def do(self):
        pass


class append_shared_resource(TrashShared):
    '''
        Добавление в корзину элементов расшаренного каталога
    '''
    def do(self):
        pass


class append_folder_with_shared(TrashShared):
    '''
        Добавление каталога, в котором есть расшаренный
    '''
    def do(self):
        pass


class append_folder_with_group(TrashShared):
    '''
        Добавление каталога, в котором есть группа
    '''
    def do(self):
        pass


class restore_to_shared(TrashShared):
    '''
        Восстановление элемента в расшаренный каталог
    '''
    def do(self):
        pass


def get_move_operation(src, dst):
    '''
        type(src) == type(dst) == filesystem.resources.base.Resource
    '''
    
