# -*- coding: utf-8 -*-

from mpfs.config import settings
from mpfs.core.filesystem.resources.disk import MPFSResource
from mpfs.core.services.comments_service import comments
from mpfs.core.event_dispatcher.events import subscribe
from mpfs.core.filesystem.events import FilesystemSetPublicEvent, FilesystemSetPrivateEvent

FEATURE_TOGGLES_NOTIFY_COMMENTS_PUBLICATION_EVENTS = settings.feature_toggles['notify_comments_publication_events']
PUBLIC_ENTITY_TYPE = 'public_resource'


def _public_comments_toggle(event, comments_func):
    if not FEATURE_TOGGLES_NOTIFY_COMMENTS_PUBLICATION_EVENTS:
        return
    resource = event.data['tgt_resource']
    if isinstance(resource, MPFSResource):
        entity_id = resource.comment_ids[PUBLIC_ENTITY_TYPE]
        comments_func(event.data['uid'], PUBLIC_ENTITY_TYPE, entity_id)


@subscribe(FilesystemSetPrivateEvent, suppress_exceptions=True)
def disable_public_comments(event):
    """Отключить публичные комментарии к ресурсу"""
    _public_comments_toggle(event, comments.disable_comments)


@subscribe(FilesystemSetPublicEvent, suppress_exceptions=True)
def enable_public_comments(event):
    """Включить публичные комментарии к ресурсу"""
    _public_comments_toggle(event, comments.enable_comments)
