# -*- coding: utf-8 -*-
from mpfs.core.address import Address
from mpfs.core.event_dispatcher.events import Event
from mpfs.core.filesystem.resources.base import Resource


class FilesystemEvent(Event):
    """Базовый класс событий файловой системы"""
    required_fields = (('uid', basestring),)


class FilesystemTargetChangeEvent(FilesystemEvent):
    """Базовый класс событий модификации файловой системы"""
    required_fields = (('tgt_resource', (Resource, type(None))),
                       ('tgt_address', Address),)

    def send_self_or_group(self, source_parent=None, target_parent=None, resource=None):
        resource_shared = resource and (resource.is_shared_internal or resource.is_group_internal)
        source_parent_shared = source_parent and (source_parent.is_shared or source_parent.is_group)
        target_parent_shared = target_parent and (target_parent.is_shared or target_parent.is_group)

        if resource_shared or source_parent_shared or target_parent_shared:
            if resource_shared:
                src_group = None
                tgt_group = resource.group
            else:
                src_group = source_parent.group if source_parent_shared else None
                tgt_group = target_parent.group if target_parent_shared else None
            FilesystemGroupChangeEvent(trigger_event=self, src_group=src_group, tgt_group=tgt_group).send()
        else:
            self.send()


class FilesystemSourceTargetChangeEvent(FilesystemTargetChangeEvent):
    """Базовый класс событий модификации файловой системы"""
    required_fields = (('src_resource', Resource),
                       ('src_address', Address),)


class FilesystemCreateDirectoryEvent(FilesystemTargetChangeEvent):
    """Событие создания папки"""


class FilesystemCreateSystemDirectoryEvent(FilesystemEvent):
    """Событие создания системной папки"""
    required_fields = (('type', basestring),)


class FilesystemCopyMoveEvent(FilesystemSourceTargetChangeEvent):
    """Базовый класс событий копирования и перемещения"""
    required_fields = (('force', bool),
                       ('overwritten', bool),)


class FilesystemCopyEvent(FilesystemCopyMoveEvent):
    """Событие копирования ресурса"""


class FilesystemMoveEvent(FilesystemCopyMoveEvent):
    """Событие перемещения ресурса"""
    required_fields = (('is_live_photo', bool),)


class FilesystemRemoveEvent(FilesystemTargetChangeEvent):
    """Событие удаления ресурса"""


class FilesystemStoreHardlinkEvent(FilesystemTargetChangeEvent):
    """Базовый класс событий загрузки ресурса в Диск: стандартных и путем копирования хардлинка"""
    required_fields = (('type', basestring),
                       ('subtype', basestring),
                       ('changes', (type(None), dict)),
                       ('size', (type(None), int)),
                       ('set_public', (type(None), bool)))


class FilesystemStoreEvent(FilesystemStoreHardlinkEvent):
    """Событие загрузки ресурса в Диск"""
    required_fields = (('is_live_photo', bool),)


class FilesystemHardlinkCopyEvent(FilesystemStoreHardlinkEvent):
    """Событие загрузки ресурса в Диск посредством копирования хардлинка"""


class FilesystemTrashAppendEvent(FilesystemSourceTargetChangeEvent):
    """Событие перемещения ресурса в Корзину"""


class FilesystemTrashDropAllEvent(FilesystemEvent):
    """Событие очистки корзины"""
    required_fields = (('owner', basestring),)


class FilesystemTrashDropEvent(FilesystemTargetChangeEvent):
    """Событие удаления ресурса из корзины"""
    required_fields = (('auto', bool),)


class FilesystemTrashRestoreEvent(FilesystemSourceTargetChangeEvent):
    """Событие восстановления файла из корзины"""
    required_fields = (
        ('type', basestring),
        ('subtype', basestring),
    )


class FilesystemSetPublicEvent(FilesystemTargetChangeEvent):
    """Событие создания публичной ссылки на ресурс"""
    required_fields = (('type', (type(None), basestring)),
                       ('subtype', (type(None), basestring)))


class FilesystemSetPrivateEvent(FilesystemTargetChangeEvent):
    """Событие удаления публичной ссылки на ресурс"""


class FilesystemGroupChangeEvent(Event):
    """Событий изменения общей папки"""
    required_fields = (('trigger_event', FilesystemTargetChangeEvent),
                       ('src_group', object), # нельзя указать mpfs.core.social.share.Group из-за циклических импортов
                       ('tgt_group', object),)
