# -*- coding: utf-8 -*-
from mpfs.common.errors import ResourceNotFound

import mpfs.engine.process
import mpfs.core.factory as factory

from mpfs.core.controllers import BaseController
from mpfs.metastorage.mongo.collections.all_user_data import AllUserDataCollection
from mpfs.common.errors import ResourceLocationMismatch
from mpfs.metastorage.mongo.binary import Binary
from mpfs.metastorage.postgres.query_executer import PGQueryExecuter
from mpfs.core.filesystem.dao.resource import ResourceDAO


dbctl = mpfs.engine.process.dbctl()
usrctl = mpfs.engine.process.usrctl()
log = mpfs.engine.process.get_default_log()


class HardlinksController(BaseController):
    def __init__(self, filter_postgres_shards=False):
        self._filter_postgres_shards = filter_postgres_shards

    def get_public_resources_by_hid(self, hid):
        result = []
        for resource in self.get_resources(hid=hid):
            if resource.is_fully_public():
                result.append(resource)
        return result

    def get_resources(self, **spec):
        """Найти все ресурсы во всех пользовательских коллекциях

        :raises ResourceNotFound: в случае, когда мы находим файлы пользователя не на том шарде, на котором он сейчас
            находится (например они остались там при миграции).
        :raises ResourceLocationMismatch: не можем получить ресурс из-за того, что пользователь живет на другом шарде
        :param dict spec:
        :rtype: collections.Iterable
        """
        # вынужденная мера
        if isinstance(spec.get('hid'), basestring):
            spec['hid'] = Binary(str(spec['hid']))
        for db_result in AllUserDataCollection(filter_postgres_shards=self._filter_postgres_shards).find(spec):
            doc = db_result.record
            try:
                yield factory.get_resource(doc['uid'], doc['key'])
            except ResourceNotFound:
                user_shard = dbctl.mapper.get_rsname_for_uid(doc['uid'])
                if user_shard != db_result.shard_name:
                    raise ResourceLocationMismatch(db_result.shard_name, db_result.collection_name, doc)
                else:
                    raise

    def get_postgres_resources_by_hid(self, hid):
        if isinstance(hid, basestring):
            hid = Binary(str(hid))

        for shard in PGQueryExecuter().get_all_shard_ids():
            resource = ResourceDAO().find_one_file_on_shard_by_hid(hid, shard)
            if resource:
                yield factory.get_resource(resource['uid'], resource['key'])

    @staticmethod
    def get_resource_by_uid_hid_for_user_data(uid, hid):
        if isinstance(hid, basestring):
            hid = Binary(str(hid))

        doc = ResourceDAO().find_one_file_by_uid_and_hid(uid, hid)
        if doc:
            return factory.get_resource_from_doc(uid, doc)
        raise ResourceNotFound()

    @staticmethod
    def is_one_owner(uid, hid):
        if isinstance(hid, basestring):
            hid = Binary(str(hid))
        return ResourceDAO().is_one_owner(uid, hid)

    @staticmethod
    def update_files_mids(hid, mids):
        """
        DEPRECATED! Не использовать. Смотри на механизм hardlink_updater

        Обновляет у файлов(hid) указанные mid-ы

        hid - у каких файлов менять mid-ы
        mids - словарь mid-ов, ключи: file_mid, pmid, digest_mid
        """
        if isinstance(hid, basestring):
            hid = Binary(str(hid))
        for db_result in AllUserDataCollection().find({'hid': hid}):
            filedata = db_result.record
            resource = factory.get_resource(filedata['uid'], filedata['key'])
            old_mids = {}
            is_changed = False
            for mid_name, new_mid in mids.iteritems():
                old_mid = resource.meta.get(mid_name)
                old_mids[mid_name] = old_mid
                if old_mid != new_mid:
                    resource.meta[mid_name] = new_mid
                    is_changed = True
            if is_changed:
                resource.save()
                log.info('Changing mids. '
                         'uid: "%s", path: "%s", '
                         'before: "%s", after: "%s"'
                         '' % (resource.uid, resource.path,
                               str(old_mids), str(mids)))
