# -*- coding: utf-8 -*-
"""

MPFS
CORE

Хардлинки
Режим мультимонги

"""
import random

import mpfs.engine.process
import mpfs.common.errors as errors

from mpfs.core.filesystem.hardlinks.common import AbstractLink
from mpfs.core.filesystem.dao.legacy import is_collection_uses_dao
from mpfs.metastorage.postgres.query_executer import PGQueryExecuter
from mpfs.core.filesystem.dao.resource import ResourceDAO

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()

dbctl = mpfs.engine.process.dbctl()


class ShardedHardLink(AbstractLink):
    """
    Шардированный хардлинк
    """
    @classmethod
    def _search_by_hid(cls, hid):
        """
        Search and return resource record in collections defined by cls.SEARCH_COLLECTIONS

        :return FileDAOItem or None
        """
        record = ResourceDAO().find_one_file_item_on_all_pg_shards_by_hid(hid)
        if record:
            return record
        raise errors.HardLinkNotFound()


    @classmethod
    def _search_by_stid(cls, stid):
        try:
            for shard in dbctl.mapper.rspool.get_all_shards_names():
                for collection in cls.SEARCH_COLLECTIONS:
                    dbctl.mapper.set_manual_route(shard)

                    if is_collection_uses_dao(collection.name):
                        ret = collection.find_by_stid(stid, shard=shard)
                    else:
                        ret = collection.find_by_stid(stid)

                    if ret.value:
                        return collection, ret
        finally:
            dbctl.mapper.drop_manual_route()

        for shard in PGQueryExecuter().get_all_shard_ids():
            for collection in cls.SEARCH_COLLECTIONS:
                ret = collection.find_by_stid(stid, shard=shard)
                if ret.value:
                    return collection, ret

        raise errors.HardLinkNotFound()

    @classmethod
    def Create(classname, md5, size, sha256, file_id, digest_id, mimetype,
               thumbnail_id=None, preview_id=None, previews=None, drweb=None, ready=False):
        """
        Создание записи хардлинка
        По сути ничего не создает, а только отдает объект с нужным ID
        """
        obj = classname(md5, size, sha256, load=False)
        return obj
