# -*- coding: utf-8 -*-
"""
Модуль содержит функции для реализации логики hardlink updater task. Зовутся динамически из update_one_hardlink.

Функция принимает на вход HardlinkUpdaterHandlerArguments
"""

import mpfs.engine.process
from mpfs.core.filesystem.cleaner.models import DeletedStid, DeletedStidSources

log = mpfs.engine.process.get_default_log()


def stid_update(args):
    """
    :param HardlinkUpdaterHandlerArguments args:
    """
    hid = args.hid
    resource = args.resource
    task_data = args.task_data

    if 'deleted_stids' not in args.context:
        args.context['deleted_stids'] = set()
    already_deleted_stids = args.context['deleted_stids']

    if 'old_mid' in task_data and resource.meta['file_mid'] != task_data['old_mid']:
        return
    elif 'old_mid' in task_data:
        task_data = task_data.copy()
        task_data.pop('old_mid')

    is_changed, old_mids = resource.update_mids(task_data)

    if is_changed:
        new_deleted_stids = []
        resource.save(skip_parents_check=True)

        for mid in old_mids.itervalues():
            if mid is not None:
                if mid not in already_deleted_stids:
                    new_deleted_stids.append(
                        DeletedStid(stid=mid, hid=hid, stid_source=DeletedStidSources.HARDLINK_UPDATE_TASK)
                    )
                    already_deleted_stids.add(mid)

        if new_deleted_stids:
            DeletedStid.controller.bulk_create(new_deleted_stids, get_size_from_storage=True)

        log.info("resource: %s old_mids: %s new_mids: %s" % (
            resource.address.id,
            old_mids,
            task_data,
            )
        )
    return
