# -*- coding: utf-8 -*-
"""

MPFS
COUNTER

Менеджер счётчиков

"""
from collections import defaultdict

import mpfs.engine.process

from mpfs.common.util import Singleton

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()


class Counter(Singleton):
    _data = defaultdict(lambda: defaultdict(int))
    _group_data = defaultdict(int)

    def __init__(self):
        from mpfs.core.services.disk_service import Disk
        from mpfs.core.services.trash_service import Trash
        self.services_map = {
            'disk': Disk,
            'trash': Trash,
        }

    def commit(self):
        for uid, counters in self._data.iteritems():
            for service, value in counters.iteritems():
                if value != 0:
                    self.services_map[service]().flush_delta(uid, value)
        from mpfs.core.social.share.group import Group
        for gid, value in self._group_data.iteritems():
            if value != 0:
                group = Group.load(gid=gid)
                group.update_group_size(value)
        self.reset()

    def add(self, counter, uid, delta):
        self._data[uid][counter] += delta
        self.services_map[counter]().cache_delta(uid, delta)

    def add_group(self, gid, delta):
        self._group_data[gid] += delta
        from mpfs.core.social.share.group import Group
        Group.load(gid=gid).size += delta

    def reset(self):
        self._data.clear()
        self._group_data.clear()
