# -*- coding: utf-8 -*-
"""

MPFS
HELPERS

Xiva хэлпер

"""

import mpfs.engine.process

from mpfs.common.static.tags.push import DIFF, SPACE, SPACE_GROUP, Full


log = mpfs.engine.process.get_default_log()


class XivaHelper(object):

    def __init__(self, filesystem):
        self.filesystem = filesystem

    def add_to_xiva(self, uid, data, old_version, new_version):
        if not isinstance(data, (list, tuple)):
            data = [data, ]

        push_data = {
            'class'      : DIFF,
            'uid'        : uid,
            'old_version': old_version,
            'new_version': new_version,
            'action_name': 'diff',
            'xiva_data'  : data,
        }
        self.filesystem.push_content.append(push_data)

    def add_to_xiva_group(self, committer, gid, data, old_version, new_version):
        if not isinstance(data, (list, tuple)):
            data = [data,]
        push_data = {
            'class'       : DIFF,
            'committer'   : committer,
            'gid'         : gid,
            'xiva_data'   : data,
            'old_version' : old_version,
            'new_version' : new_version,
            'action_name' : 'diff_group'
        }
        self.filesystem.push_content.append(push_data)

    def add_to_xiva_group_move(self, committer, source, target, old_version_src, old_version_tgt, new_version_src, new_version_tgt):
        data = {
            'class'           : DIFF,
            'committer'       : committer,
            'xiva_data'       : {'source' : source, 'target' : target},
            'old_version_src' : old_version_src,
            'old_version_tgt' : old_version_tgt,
            'new_version_src' : new_version_src,
            'new_version_tgt' : new_version_tgt,
            'action_name'     : 'diff_group_move',
        }
        self.filesystem.push_content.append(data)

    def add_to_xiva_group_trash_append(self, committer, source, target, old_version_src, new_version_src):
        data = {
            'class'           : DIFF,
            'committer'       : committer,
            'xiva_data'       : {'source' : source, 'target' : target},
            'old_version_src' : old_version_src,
            'new_version_src' : new_version_src,
            'action_name'     : 'diff_group_trash_append',
        }
        self.filesystem.push_content.append(data)

    def add_to_xiva_space(self, uid):
        if self.filesystem.method not in ('mkfile', 'copy_resource', 'hardlink_copy', ):
            return
        else:
            space_info = self.filesystem.quota.report(uid)
            push_tag = self.filesystem.quota.get_push_type(uid)
            if push_tag:
                limit = space_info['limit']
                used = space_info['used']
                free = space_info['free']
                xiva_data = {
                         'root' : {
                            'tag' : SPACE,
                            'parameters' : {
                                'type' : push_tag.type,
                                'limit' : limit,
                                'free' : free,
                                'used' : used,
                                },
                            },
                        'values' : [],
                        }
                data = {
                    'class': push_tag.klass,
                    'uid' : uid,
                    'new_version' : 1,
                    'xiva_data' : xiva_data,
                    'connection_id' : self.filesystem.connection_id,
                    'operation' : 'action',
                    'action_name' : SPACE,
                    }
                self.filesystem.push_content.append(data)
                email_data = {
                    'uid': uid,
                    'template': push_tag.template,
                    'data': space_info,
                }

                from mpfs.core.user.base import User  # цикл. импорт
                user = User(uid)
                if user.is_b2b():
                    if push_tag.type == Full.type:
                        email_data['template'] = 'b2b/space/finished'
                    else:
                        return
                self.filesystem.email_content['send_email_space'].append(email_data)

    def add_to_xiva_space_group(self, uid, gid):
        if self.filesystem.method not in ('mkfile', 'copy_resource', 'move_resource', 'hardlink_copy',):
            return
        else:
            data = {
                    'new_version' : 1,
                    'committer' : uid,
                    'gid' : gid,
                    'connection_id' : self.filesystem.connection_id,
                    'operation' : 'action',
                    'action_name' : SPACE_GROUP,
                    'method' : self.filesystem.method,
                    }
            self.filesystem.push_content.append(data)

