# -*- coding: utf-8 -*-
import datetime
import hashlib

from mpfs.core.models import Model, ModelField


class IIDDocument(Model):
    primary_key_field = 'id'

    id = ModelField(source='_id')
    iid = ModelField(required=True)
    ctime = ModelField(required=True)
    incoming_raw_address = ModelField(required=True)
    outgoing_raw_address = ModelField(required=True)

    def __init__(self, **kwargs):
        super(IIDDocument, self).__init__(**kwargs)
        if kwargs.get('id') is None:
            self.id = self.generate_id(self.iid, self.incoming_raw_address)
        if not isinstance(kwargs.get('ctime'), datetime.datetime):
            self.ctime = datetime.datetime.now()

    @staticmethod
    def generate_id(iid, incoming_raw_address):
        str_id = u"%s%s" % (iid, incoming_raw_address)
        str_id = str_id.encode('utf-8')
        return hashlib.md5(str_id).hexdigest()

    def as_json_dict(self):
        return {
            'id': self.id,
            'iid': self.iid,
            'ctime': str(self.ctime),
            'incoming_raw_address': self.incoming_raw_address,
            'outgoing_raw_address': self.outgoing_raw_address,
        }
