# -*- coding: utf-8 -*-
import datetime
import hashlib
import uuid

from mpfs.core.filesystem.dao.resource import AdditionalDataDAO
from mpfs.core.filesystem.resources.base import Resource
from mpfs.core.user.constants import ADDITIONAL_AREA_PATH


class LivePhotoFilesManager(object):
    @staticmethod
    def copy_live_video_file(live_photo_src_address, live_photo_dst_address, new_values_to_generate=None):
        additional_data_dao = AdditionalDataDAO()

        live_video_file = additional_data_dao.get_additional_file(
            live_photo_src_address, AdditionalDataDAO.LIVE_VIDEO_TYPE
        )

        uid = live_photo_dst_address.uid
        live_video_file.uid = uid
        live_video_file.path = ADDITIONAL_AREA_PATH + '/' + uuid.uuid4().hex

        if new_values_to_generate:
            if 'ctime' in new_values_to_generate:
                live_video_file.creation_time = datetime.datetime.now().replace(microsecond=0)
            if 'mtime' in new_values_to_generate:
                live_video_file.modification_time = datetime.datetime.now().replace(microsecond=0)
            if 'file_id' in new_values_to_generate:
                live_video_file.file_id = Resource.generate_file_id(live_video_file.uid, live_video_file.path)

        from mpfs.core.metastorage.control import additional_data
        if live_photo_src_address.uid != uid and not additional_data.check(uid):
            additional_data.create(uid)
            additional_data.make_folder(uid, ADDITIONAL_AREA_PATH, {})

        additional_data_dao.insert_additional_file(live_video_file)
        additional_data_dao.link_additional_file(
            uid,
            live_photo_dst_address.path,
            live_video_file.path,
            AdditionalDataDAO.LIVE_VIDEO_TYPE
        )

    @staticmethod
    def remove_live_video(live_photo_address):
        additional_data_dao = AdditionalDataDAO()

        live_video_file = additional_data_dao.get_additional_file(
            live_photo_address, AdditionalDataDAO.LIVE_VIDEO_TYPE
        )
        additional_data_dao.unlink_additional_file(
            live_photo_address.uid, live_photo_address.path, live_video_file.path
        )
        additional_data_dao.remove_additional_file(live_video_file)

    @staticmethod
    def get_live_photo_store_operation_id(uid, raw_address, md5, sha256, size,
                                          live_photo_md5, live_photo_sha256, live_photo_size):
        oid_parts = (
            uid, raw_address,
            md5, sha256, str(size),
            live_photo_md5, live_photo_sha256, str(live_photo_size)
        )
        encoded = (''.join(oid_parts)).encode('utf-8')
        return hashlib.sha256(encoded).hexdigest()

    @staticmethod
    def get_paired_live_photo_store_operation_id(uid, raw_address, md5, sha256, size,
                                                 live_photo_md5, live_photo_sha256, live_photo_size):
        return LivePhotoFilesManager.get_live_photo_store_operation_id(
            uid, raw_address,
            live_photo_md5, live_photo_sha256, live_photo_size,
            md5, sha256, size
        )
