# -*- coding: utf-8 -*-
import os
from mpfs.core.user.constants import (
    DEFAULT_FOLDERS,
    PHOTOUNLIM_AREA_PATH,
    DISK_AREA_PATH,
)

# https://st.yandex-team.ru/CHEMODAN-38595#1509457385000
IGNORE_MD5 = {
    '569a1c98696050439b5b2a1ecfa52d19',  # Мишки.jpg
    'd27d72a3059ad5ebed7a5470459d2670',  # Москва.jpg
    'a64146fee5e15b3b94c204e544426d43',  # Зима.jpg
    'ab903d9cab031eca2a8f12f37bbc9d37',  # Море.jpg
    '1392851f0668017168ee4b5a59d66e7b',  # Горы.jpg
    'f1abe3b27b410128623fd1ca00a45c29',  # Санкт-Петербург.jpg
}
PHOTOCAMERA_FOLDER_NAMES = {i.split('/', 3)[2] for i in DEFAULT_FOLDERS['photostream'].values()}


def get_photoslice_time(path, resource_type, mimetype, md5, etime, ctime, mtime):
    if is_photoslice_file(path, resource_type, mimetype, md5, etime):
        return etime or ctime or mtime
    return None


def is_photoslice_file(path, resource_type, mimetype, md5, etime):
    """
    Является ли файл фотосрезным или нет.

    Этот код надо синхронизировать с поиском. Без консультацией с ними не править.

    images-filter
    https://git.yandex-team.ru/gitweb/saas/personal.git?a=blob;f=src/yadisk-search-proxy/main/bundle/yadisk-search-proxy-prod.conf;h=b97211dece70790b47a18829932bb6801d458cfe;hb=HEAD#l102
    """
    if not mimetype:
        return False
    if resource_type != 'file':
        return False
    if md5 in IGNORE_MD5:
        return False

    if path.startswith(PHOTOUNLIM_AREA_PATH):
        if mimetype.startswith('image/'):
            return True
        elif mimetype.startswith('video/'):
            ext = os.path.splitext(path)[1].lower()
            if ext in ('.mkv', '.avi'):
                return False
            return True
        elif mimetype in ('application/vnd.rn-realmedia', 'application/vnd.rn-realmedia-vbr', 'application/mp4'):
            return True
    elif path.startswith(DISK_AREA_PATH):
        if etime and mimetype in ('image/jpeg', 'image/tiff'):
            return True
        if mimetype in ('image/heic', 'image/heif'):
            return True
        sub_folder = path.split('/', 3)[2]
        if sub_folder in PHOTOCAMERA_FOLDER_NAMES:
            if mimetype in ('application/vnd.rn-realmedia', 'application/vnd.rn-realmedia-vbr', 'application/mp4', 'image/png', 'image/jpeg', 'image/tiff'):
                return True
            elif mimetype.startswith('video/'):
                return True
    return False
