# -*- coding: utf-8 -*-
"""

MPFS
CORE

Скрытые ресурсы в хранилище
Hidden resources

"""

import mpfs.engine.process

from mpfs.common import errors
from mpfs.core.address import Address
from mpfs.core.filesystem.resources.disk import MPFSFile, MPFSFolder
from mpfs.core.services.hidden_files_service import Hidden


log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()


class HiddenFile(MPFSFile):

    service_class = Hidden

    def dir(self):
        result = super(HiddenFile, self).dir()
        result['dtime'] = None  # дата удаления
        return result

    @classmethod
    def from_dict(cls, data, user_principal=None):
        address = Address.Make(data['uid'], data['key'])
        if address.storage_name != 'hidden':
            raise errors.ResourceNotFound()
        return super(HiddenFile, cls).from_dict(data, user_principal=user_principal)

    @property
    def is_hidden(self):
        return True


class HiddenFolder(MPFSFolder):

    service_class = Hidden
    file_class = HiddenFile

    def dir(self):
        result = super(HiddenFolder, self).dir()
        result['dtime'] = None  # дата удаления
        return result

    def list(self):
        if not self.request or self.request.get_type() in ('support'):
            return super(HiddenFolder, self).list()
        else:
            raise errors.PermissionDenied

    @classmethod
    def from_dict(cls, data, user_principal=None):
        address = Address.Make(data['uid'], data['key'])
        if address.storage_name != 'hidden':
            raise errors.ResourceNotFound()
        return super(HiddenFolder, cls).from_dict(data, user_principal=user_principal)

    @property
    def is_hidden(self):
        return True
