# -*- coding: utf-8 -*-
"""

MPFS
CORE

Почтовые аттачи + Перемещенный Народ

"""
import traceback
from time import time as current_time

import mpfs.engine.process

from mpfs.common.util.crypt import CryptAgent
from mpfs.core.filesystem.resources.disk import MPFSFile, MPFSFolder, DiskResource
from mpfs.core.services.clck_service import clck
from mpfs.common import errors
from mpfs.core.address import Address

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()
crypt_agent = CryptAgent()


class LegacyResource(DiskResource):
    
    def make_public(self, symlink):
        '''
        Особая публикация аттача с почты и старонародного добра
        Позволяет работать, даже если clck упал
        
        https://jira.yandex-team.ru/browse/CHEMODAN-5999
        '''
        self.meta['symlink'] = symlink.address.id
        hsh = crypt_agent.encrypt(self.get_symlink())
        self.meta['public'] = 1
        self.meta['public_hash'] = hsh
        if self.get_public_url() is not None:
            try:
                has_preview = self.meta.get('pmid') or self.meta.get('previews')
                mode = 'image' if has_preview else 'default'  
                _, short_url = clck.generate(self.get_public_url(), mode=mode)
                self.meta['short_url'] = short_url
                self.meta['short_url_named'] = short_url + '?' + self.name
            except Exception:
                error_log.info(traceback.format_exc())
                self.meta['short_url'] = self.get_public_url()
                self.meta['short_url_named'] = self.get_public_url() 
            finally:
                self.save()



class LegacyFile(MPFSFile, LegacyResource):

    service_class = None

    def __init__(self, *args, **kwargs):
        MPFSFile.__init__(self, *args, **kwargs)
        LegacyResource.__init__(self, *args, **kwargs)
        try:
            self.name = self.meta['original_name']
        except KeyError:
            pass
        self.setup(**kwargs)
        
    
class LegacyFolder(MPFSFolder, LegacyResource):

    file_class = LegacyFile
    service_class = None

    def __init__(self, *args, **kwargs):
        MPFSFolder.__init__(self, *args, **kwargs)
        LegacyResource.__init__(self, *args, **kwargs)
        try:
            self.name = self.meta['original_name']
        except KeyError:
            pass
        
        
