# -*- coding: utf-8 -*-
"""

MPFS
CORE

Папка Mail

"""

import mpfs.engine.process
import mpfs.common.util.logger as logger
import mpfs.common.errors as errors

from mpfs.core.filesystem.resources.base import Folder, File
from mpfs.core.services.mail_service import Mail
from mpfs.core.address import Address


log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()


class MailFile(File):

    service_class = Mail

    def __init__(self, *args, **kwargs):
        super(MailFile, self).__init__(*args, **kwargs)
        self.name = kwargs.get('data', {}).get('name') or self.name

    def fill(self, address, **args):
        self._service.load_file(self)
        self.type = 'file'

    def info(self, **params):
        return {'this' : self.dict()}

    def get_url(self, **args):
        _url = self.meta.get('url', '')
        if args.get('inline'):
            _url += "&no_disposition=y"
        return { 'file': _url }

    def get_file_url(self, **args):
        return self.meta.get('url', '')

    def get_direct_url(self, modified=None):
        stid = self.meta.get('stid')
        part = self.meta.get('part')
        if not (stid and part):
            raise errors.FileNotFound()

        return {
            'url' : self._service.direct_url(stid, part),
            'mimetype' : self.mimetype,
            'name' : self.name
        }

    def get_webattach_url(self, modified=None):
        return {
            'file': self._service.webattach_url(self),
        }

    @classmethod
    def from_dict(cls, data, user_principal=None):
        address = Address.Make(data['uid'], data['key'])
        if address.storage_name != 'mail':
            raise errors.ResourceNotFound()
        return super(MailFile, cls).from_dict(data, user_principal=user_principal)


class MailFolder(Folder):

    file_class = MailFile
    service_class = Mail

    def __init__(self, *args, **kwargs):
        super(MailFolder, self).__init__(*args, **kwargs)
        self.name = kwargs.get('data', {}).get('name') or self.name
        self.type = 'dir'

    def info(self, **params):
        return {'this' : self.dict()}

    def timeline(self, **params):
        sort_field = self.form.args['bounds'].get('sort') or params.get('sort', 'name')
        self._service.timeline(self)
        if self.form.args['filter']:
            self.form.args['bounds']['sort'] = sort_field

    def tree(self, **params):
        '''
        Рекурсивный проход по списку вложенных каталогов.
        По умолчанию проходит по первому уровню вложенности.
        '''
        sort_field = self.form.args['bounds'].get('sort') or params.get('sort', 'name')
        return self._service.tree(self)

    # BULLSHIT
    def construct_child_file(self, fid, data):
        fle = self.file_class(self.uid, Address(fid), data=data)
        if self.request:
            fle.set_request(self.request)
        self.children_items['files'].append(fle)
        return fle

    # BULLSHIT
    def construct_child_folder(self, fid, data):
        fol = self.__class__(self.uid, Address(fid), data=data)
        if self.request:
            fol.set_request(self.request)
        self.children_items['folders'].append(fol)
        return fol

    @classmethod
    def from_dict(cls, data, user_principal=None):
        address = Address.Make(data['uid'], data['key'])
        if address.storage_name != 'mail':
            raise errors.ResourceNotFound()
        return super(MailFolder, cls).from_dict(data, user_principal=user_principal)
