# -*- coding: utf-8 -*-
"""

MPFS
CORE

Хранение чего угодно 

"""
import mpfs.engine.process

from mpfs.core.address import Address
from mpfs.common import errors
from mpfs.core.filesystem.resources.disk import DiskFile, DiskFolder
from mpfs.core.services.misc_service import Misc

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()


class MiscFile(DiskFile):
    
    service_class = Misc

    @classmethod
    def from_dict(cls, data, user_principal=None):
        address = Address.Make(data['uid'], data['key'])
        if address.storage_name != 'settings':
            raise errors.ResourceNotFound()
        return super(DiskFile, cls).from_dict(data, user_principal=user_principal)


class MiscFolder(DiskFolder):

    file_class = MiscFile
    service_class = Misc

    @classmethod
    def from_dict(cls, data, user_principal=None):
        address = Address.Make(data['uid'], data['key'])
        if address.storage_name != 'settings':
            raise errors.ResourceNotFound()
        return super(DiskFolder, cls).from_dict(data, user_principal=user_principal)
