# -*- coding: utf-8 -*-
"""

MPFS
CORE

Мулечный виртуальный ресурс

"""
import os

import mpfs.engine.process
import mpfs.common.util.logger as logger
import mpfs.common.errors as errors

from mpfs.core.filesystem.resources.base import Folder, File
from mpfs.core.services.mulca_service import Mulca
from mpfs.core.address import Address

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()

class MulcaFile(File):

    service_class = Mulca
    
    def setup(self, **args):
        chunks = self.id.split(os.path.sep).pop(-1).split(':')
        
        self.meta = {
            'part': chunks.pop(-1),
            'stid': ':'.join(chunks),
        }
         
    def get_direct_url(self, *args):
        return {
            'url'     : self._service.get_local_url(self.meta['stid']),
            'name'    : self.name,
            'mimetype': '',
        }


class MulcaFolder(Folder):

    file_class = MulcaFile
    service_class = Mulca

    @classmethod
    def from_dict(cls, data, user_principal=None):
        address = Address.Make(data['uid'], data['key'])
        if address.storage_name != 'mulca':
            raise errors.ResourceNotFound()
        return super(MulcaFolder, cls).from_dict(data, user_principal=user_principal)
