# -*- coding: utf-8 -*-
"""

MPFS
CORE

Папка Narod

"""

import mpfs.engine.process
import mpfs.common.util.logger as logger
import mpfs.common.errors as errors

from mpfs.engine.http.client import open_url
from mpfs.core.filesystem.resources.base import Folder, File
from mpfs.core.filesystem.resources.legacy import LegacyFile, LegacyFolder
from mpfs.core.services.narod_service import LegacyNarod, OriginalNarod
from mpfs.core.address import Address


log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()



def NarodFile(*args, **kwargs):
    uid = args[0]
    address = args[1]
    address.change_storage('lnarod')
    return LegacyNarodFile(*args, **kwargs) 
    
def NarodFolder(*args, **kwargs): 
    uid = args[0]
    address = args[1]
    address.change_storage('lnarod')
    return LegacyNarodFolder(*args, **kwargs)

    
    
'''
Все, что ниже, можно смело отпилить
'''
def is_migrated(uid):
    try:
        from mpfs.core.user.base import User
        return User(uid).states.get('narod_migrated')
    except errors.StorageInitUser, e:
        return False


class OriginalNarodFile(File):

    service_class = OriginalNarod

    def fill(self, address, **args):
        return self._service.load_file(self)

    def get_file_url(self, **args):
        return self.meta.get('url')

    def get_url(self, **args):
        _url = self.meta['file_url']
        if args.get('inline'):
            _url += '?inline=1'
        return { 'file': _url }

    def get_direct_url(self, modified=None):
        return {
            'url' : self.meta.get('url'),
            'mimetype': self.mimetype,
            'name': self.name
        }


class OriginalNarodFolder(Folder):

    file_class = OriginalNarodFile
    service_class = OriginalNarod

    def load(self):
        return self._service.listing(self)

    
class LegacyNarodFile(LegacyFile):

    service_class = LegacyNarod

    
class LegacyNarodFolder(LegacyFolder):

    file_class = LegacyNarodFile
    service_class = LegacyNarod

    @classmethod
    def from_dict(cls, data, user_principal=None):
        address = Address.Make(data['uid'], data['key'])
        if address.storage_name != 'lnarod':
            raise errors.ResourceNotFound()
        return super(LegacyNarodFolder, cls).from_dict(data, user_principal=user_principal)
