# -*- coding: utf-8 -*-
"""

MPFS
CORE

Фотопоток

"""

import mpfs.engine.process

from mpfs.core.address import Address
from mpfs.common import errors
from mpfs.core.filesystem.resources.disk import MPFSFile, MPFSFolder
from mpfs.core.services.photostream_service import Photostream

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()


class PhotostreamFile(MPFSFile):

    service_class = Photostream


class PhotostreamFolder(MPFSFolder):

    file_class = PhotostreamFile
    service_class = Photostream

    @classmethod
    def from_dict(cls, data, user_principal=None):
        address = Address.Make(data['uid'], data['key'])
        if address.storage_name != 'photostream':
            raise errors.ResourceNotFound()
        return super(PhotostreamFolder, cls).from_dict(data, user_principal=user_principal)
