# -*- coding: utf-8 -*-
"""

MPFS
CORE

Корневая папка

"""
import mpfs.engine.process

from mpfs.config import settings
from mpfs.core.address import Address
from mpfs.core.filesystem.resources.base import Folder
from mpfs.core.services.common_service import Service
from mpfs.common import errors
from mpfs.core.user.constants import PHOTOUNLIM_AREA_PATH, ADDITIONAL_AREA_PATH, CLIENT_AREA_PATH

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()


class RootFolder(Folder):
    service_class = Service
    ROOT_CHILD_FOLDERS = ('/narod', '/disk', '/fotki', '/mail',
                          '/trash', '/share', '/attach', '/notes',
                          PHOTOUNLIM_AREA_PATH, ADDITIONAL_AREA_PATH, CLIENT_AREA_PATH)

    def list(self, **params):
        self.load()

        result = []
        for folder in self.children_items['folders']:
            folder_dict = folder.dict()
            
            try:
                folder.load()
                folder.status_dict = {'value' : 1}
                folder_dict['value'] = 1
            except Exception, ae:
                folder.status_dict = {'value' : 0}
                if isinstance(ae, errors.APIError):
                    folder.status_dict.update({
                        'message' : ae.message,
                        'code' : ae.code,
                    })
                    folder_dict['status_dict'].update({
                        'message' : ae.message,
                        'code' : ae.code,
                    })
            result.append(folder_dict)

        _description = self.dict()
        return {'this': _description, 'list': result}

    def load(self):
        result = []
        for folder_name in self.ROOT_CHILD_FOLDERS:
            try:
                address = self.address.get_child_folder(folder_name)
                folder  = self.construct(self.committer, address)
                if self.request:
                    folder.set_request(self.request)
                folder_dict = folder.dict()
                self.children_items['folders'].append(folder)
                self.child_folders[folder_name] = folder_dict
                result.append(folder_dict)
            except errors.FeatureDisabled:
                pass
        return result

    def tree(self, **params):
        '''
        Рекурсивный проход по списку вложенных каталогов.
        По умолчанию проходит по первому уровню вложенности.
        '''
        self.load()

        level = params.pop('level', 1) or 1
        parent = params.pop('parent', '/')
        if not parent: parent = '/'
        if level is None: level = 1

        children_list = []

        if level > 0 or self.request.deep_level == -1:
            if level > 0:
                level = level - 1
            for subfolder in self.children_items['folders']:
                try:
                    subfolder.status_dict = {'value' : 1}
                    params['parent'] = subfolder.id
                    params['level'] = level
                    children_list.append(subfolder.tree(**params))
                except Exception, ae:
                    import traceback
                    error_log.info(traceback.format_exc())
                    subfolder.status_dict = {'value' : 0}
                    ch_val = {
                        'id': subfolder.id,
                        'name': subfolder.name,
                        'meta': {},
                        'status_dict' : {
                            'value' : 0,
                        }
                    }
                    if isinstance(ae, errors.APIError):
                        subfolder.update({
                            'message' : ae.message,
                            'code' : ae.code,
                        })
                        ch_val['status_dict'].update({
                            'message' : ae.message,
                            'code' : ae.code,
                        })
                    children_list.append({'this' : ch_val, 'list' : []})

        result = {'this': self.dict(), 'list': children_list}
        return result


    def services(self, **params):
        '''
        Выдача списка сервисов 
        '''
        self.load()
        result = []
        for folder in self.children_items['folders']:
            if folder.path in settings.folder_types['dynamic']:
                folder.load()
            result.append({'this': folder.dict(), 'list': []})
        return {'this': self.dict(), 'list': result}

    @classmethod
    def from_dict(cls, data, user_principal=None):
        address = Address.Make(data['uid'], data['key'])
        if address.storage_name != '/':
            raise errors.ResourceNotFound()
        return super(RootFolder, cls).from_dict(data, user_principal=user_principal)
