# -*- coding: utf-8 -*-
"""

MPFS
CORE

YaReader

"""

from copy import deepcopy


import mpfs.engine.process

from mpfs.core.address import Address
from mpfs.common import errors
from mpfs.core.filesystem.resources.disk import MPFSFile, MPFSFolder
from mpfs.core.services.yareader_service import YaReader

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()


class YaReaderResource(object):
    def __init__(self, *args, **kwargs):
        self.storage_address = deepcopy(self.address)
        self.storage_address.change_storage('disk')
        self.address = self.storage_address


class YaReaderFile(YaReaderResource, MPFSFile):

    service_class = YaReader

    def __init__(self, uid, address, **args):
        MPFSFile.__init__(self, uid, address, **args)
        YaReaderResource.__init__(self, uid, address, **args)
    

class YaReaderFolder(YaReaderResource, MPFSFolder):

    file_class = YaReaderFile
    service_class = YaReader

    def __init__(self, uid, address, **args):
        MPFSFolder.__init__(self, uid, address, **args)
        YaReaderResource.__init__(self, uid, address, **args)

    def list(self, *args, **kwargs):
        if self.request:
            self.form.args['filter'].update({'media_type' : 'book'})
        return super(YaReaderFolder, self).timeline()

    @classmethod
    def from_dict(cls, data, user_principal=None):
        address = Address.Make(data['uid'], data['key'])
        if address.storage_name != 'yareader':
            raise errors.ResourceNotFound()
        return super(YaReaderFolder, cls).from_dict(data, user_principal=user_principal)
