
import mpfs.engine.process

from mpfs.core.address import Address
from mpfs.common import errors
from mpfs.core.filesystem.resources.base import File, Folder
from mpfs.core.services.yavideo_service import YaVideo

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()


class YaVideoFile(File):
    service_class = YaVideo

    def __init__(self, uid, address, **args):
        super(YaVideoFile, self).__init__(uid, address, **args)
        setattr(self, 'media_type', 'video')
        
    def get_file_url(self, **args):
        return self.meta.get('url', '')

    def get_url(self, **args):
        return { 'file': self.get_file_url() }

    def rm(self, *args, **kwargs):
        return 0

    def info(self, **params):
        return {'this': self.dict()}

    def fill(self, address, **args):
        film = self._service.get_film(address)
        self.update(film)

    def check_lock(self):
        return False

    def lock(self):
        pass

    def unlock(self):
        pass


class YaVideoFolder(Folder):
    service_class = YaVideo
    file_class = YaVideoFile
    static_fields = ('userId', 'albumId')

    # Yandex Video cant have nested folders
    def count_folders(self):
        return 0

    def rm(self, *args, **kwargs):
        return 0

    @classmethod
    def from_dict(cls, data, user_principal=None):
        address = Address.Make(data['uid'], data['key'])
        if address.storage_name != 'yavideo':
            raise errors.ResourceNotFound()
        return super(YaVideoFolder, cls).from_dict(data, user_principal=user_principal)
