# -*- coding: utf-8 -*-
import mpfs.engine.process

from mpfs.core.metastorage.control import disk
from mpfs.common.forms.folder import FolderForm


log = mpfs.engine.process.get_default_log()


class History(object):

    def __init__(self, model):
        self.model = model
        self.items = []
        self.form = FolderForm(self)
        self.children_items = {'folders' : [], 'files' : []}

    def diff(self, version, allow_quick_move_deltas):
        versioned = str(version) != 'None'
        version = version if versioned else None

        result = disk.diff(self.model.uid, self.model.id, version, allow_quick_move_deltas=allow_quick_move_deltas)

        return {'result': result.value, 'version': result.version, 'amount': len(result.value)}
