# -*- coding: utf-8 -*-
"""

MPFS
BILLING

Обработчики очереди

"""
import mpfs.engine.process

from mpfs.core.billing.processing import repair
from mpfs.core.billing.processing import billing
from mpfs.engine.queue2.celery import BaseTask, app

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()


@app.task(base=BaseTask)
def handle_billing_order_callback(
        number, status, status_code, uid, mode=None, trust_refund_id=None, context=None, **kwargs):

    if uid:
        repair.recalculate_limit_by_services(uid)
    billing.order_process_callback(uid, number, status, status_code, mode, trust_refund_id)


@app.task(base=BaseTask)
def handle_billing_subscription_callback(
        number, status, status_code, mode, uid=None, trust_refund_id=None, context=None, **kwargs):

    if uid:
        repair.recalculate_limit_by_services(uid)
    billing.subscription_process_callback(uid, number, status, status_code, mode, trust_refund_id)


@app.task(base=BaseTask)
def handle_mediabilling_subscription_ok(number, status, status_code, expires, uid=None, pid=None,
                                        price=None, currency=None, context=None, **kwargs):
    if uid:
        repair.recalculate_limit_by_services(uid)
    billing.mediabilling_subscription_process_ok_callback(uid, number, status, status_code, expires,
                                                          pid=pid, price=price, currency=currency)


@app.task(base=BaseTask)
def handle_billing_service_standart_billing(uid, sid, context=None, **kwargs):
    repair.recalculate_limit_by_services(uid)
    billing.service_process_billing(uid, sid)


@app.task(base=BaseTask)
def handle_billing_service_subscription_delayed(uid, sid, context=None, **kwargs):
    repair.recalculate_limit_by_services(uid)
    billing.service_process_subscription_delayed(uid, sid)


@app.task(base=BaseTask)
def handle_billing_service_subscription_cancelled(uid, sid, context=None, **kwargs):
    repair.recalculate_limit_by_services(uid)
    billing.service_process_subscription_cancelled(uid, sid)


@app.task(base=BaseTask)
def handle_mediabilling_subscription_cancelled(uid, sid, contex=None, **kwargs):
    repair.recalculate_limit_by_services(uid)
    billing.service_process_mediabilling_subscription_cancelled(uid, sid)


@app.task(base=BaseTask)
def handle_billing_inapp_service_syncronize(uid, sid, context=None, **kwargs):
    # in-app MVP1
    repair.recalculate_limit_by_services(uid)
    billing.inapp_service_syncronize(uid, sid)


@app.task(base=BaseTask)
def handle_billing_resync_inapp_subs(trust_subs_id, context=None, **kwargs):
    # in-app MVP2
    from mpfs.core.billing.inapp.sync_logic import InAppResyncManager
    InAppResyncManager.resync_by_trust_subs_id(trust_subs_id)
